import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#content LogicAppIntegrationAccountSchema#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#file_name LogicAppIntegrationAccountSchema#file_name}.
     *
     * @stability stable
     */
    readonly fileName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#integration_account_name LogicAppIntegrationAccountSchema#integration_account_name}.
     *
     * @stability stable
     */
    readonly integrationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#metadata LogicAppIntegrationAccountSchema#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#name LogicAppIntegrationAccountSchema#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#resource_group_name LogicAppIntegrationAccountSchema#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#timeouts LogicAppIntegrationAccountSchema#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppIntegrationAccountSchemaTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountSchemaTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#create LogicAppIntegrationAccountSchema#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#delete LogicAppIntegrationAccountSchema#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#read LogicAppIntegrationAccountSchema#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html#update LogicAppIntegrationAccountSchema#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppIntegrationAccountSchemaTimeoutsToTerraform(struct?: LogicAppIntegrationAccountSchemaTimeoutsOutputReference | LogicAppIntegrationAccountSchemaTimeouts): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountSchemaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountSchemaTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountSchemaTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html azurerm_logic_app_integration_account_schema}.
 *
 * @stability stable
 */
export declare class LogicAppIntegrationAccountSchema extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_schema.html azurerm_logic_app_integration_account_schema} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppIntegrationAccountSchemaConfig);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _fileName?;
    /**
     * @stability stable
     */
    get fileName(): string;
    /**
     * @stability stable
     */
    set fileName(value: string);
    /**
     * @stability stable
     */
    resetFileName(): void;
    /**
     * @stability stable
     */
    get fileNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationAccountName?;
    /**
     * @stability stable
     */
    get integrationAccountName(): string;
    /**
     * @stability stable
     */
    set integrationAccountName(value: string);
    /**
     * @stability stable
     */
    get integrationAccountNameInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppIntegrationAccountSchemaTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppIntegrationAccountSchemaTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppIntegrationAccountSchemaTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
