import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#enabled MonitorAutoscaleSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#location MonitorAutoscaleSetting#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#name MonitorAutoscaleSetting#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#resource_group_name MonitorAutoscaleSetting#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#tags MonitorAutoscaleSetting#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#target_resource_id MonitorAutoscaleSetting#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#notification MonitorAutoscaleSetting#notification}
     *
     * @stability stable
     */
    readonly notification?: MonitorAutoscaleSettingNotification;
    /**
     * profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#profile MonitorAutoscaleSetting#profile}
     *
     * @stability stable
     */
    readonly profile: MonitorAutoscaleSettingProfile[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#timeouts MonitorAutoscaleSetting#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorAutoscaleSettingTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingNotificationEmail {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#custom_emails MonitorAutoscaleSetting#custom_emails}.
     *
     * @stability stable
     */
    readonly customEmails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#send_to_subscription_administrator MonitorAutoscaleSetting#send_to_subscription_administrator}.
     *
     * @stability stable
     */
    readonly sendToSubscriptionAdministrator?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#send_to_subscription_co_administrator MonitorAutoscaleSetting#send_to_subscription_co_administrator}.
     *
     * @stability stable
     */
    readonly sendToSubscriptionCoAdministrator?: boolean | cdktf.IResolvable;
}
export declare function monitorAutoscaleSettingNotificationEmailToTerraform(struct?: MonitorAutoscaleSettingNotificationEmailOutputReference | MonitorAutoscaleSettingNotificationEmail): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingNotificationEmailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingNotificationEmail | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingNotificationEmail | undefined);
    private _customEmails?;
    /**
     * @stability stable
     */
    get customEmails(): string[];
    /**
     * @stability stable
     */
    set customEmails(value: string[]);
    /**
     * @stability stable
     */
    resetCustomEmails(): void;
    /**
     * @stability stable
     */
    get customEmailsInput(): string[] | undefined;
    private _sendToSubscriptionAdministrator?;
    /**
     * @stability stable
     */
    get sendToSubscriptionAdministrator(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendToSubscriptionAdministrator(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendToSubscriptionAdministrator(): void;
    /**
     * @stability stable
     */
    get sendToSubscriptionAdministratorInput(): boolean | cdktf.IResolvable | undefined;
    private _sendToSubscriptionCoAdministrator?;
    /**
     * @stability stable
     */
    get sendToSubscriptionCoAdministrator(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendToSubscriptionCoAdministrator(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendToSubscriptionCoAdministrator(): void;
    /**
     * @stability stable
     */
    get sendToSubscriptionCoAdministratorInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingNotificationWebhook {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#properties MonitorAutoscaleSetting#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#service_uri MonitorAutoscaleSetting#service_uri}.
     *
     * @stability stable
     */
    readonly serviceUri: string;
}
export declare function monitorAutoscaleSettingNotificationWebhookToTerraform(struct?: MonitorAutoscaleSettingNotificationWebhook): any;
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingNotification {
    /**
     * email block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#email MonitorAutoscaleSetting#email}
     *
     * @stability stable
     */
    readonly email?: MonitorAutoscaleSettingNotificationEmail;
    /**
     * webhook block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#webhook MonitorAutoscaleSetting#webhook}
     *
     * @stability stable
     */
    readonly webhook?: MonitorAutoscaleSettingNotificationWebhook[];
}
export declare function monitorAutoscaleSettingNotificationToTerraform(struct?: MonitorAutoscaleSettingNotificationOutputReference | MonitorAutoscaleSettingNotification): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingNotification | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingNotification | undefined);
    private _email;
    /**
     * @stability stable
     */
    get email(): MonitorAutoscaleSettingNotificationEmailOutputReference;
    /**
     * @stability stable
     */
    putEmail(value: MonitorAutoscaleSettingNotificationEmail): void;
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): MonitorAutoscaleSettingNotificationEmail | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): MonitorAutoscaleSettingNotificationWebhook[];
    /**
     * @stability stable
     */
    set webhook(value: MonitorAutoscaleSettingNotificationWebhook[]);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): MonitorAutoscaleSettingNotificationWebhook[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileCapacity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#default MonitorAutoscaleSetting#default}.
     *
     * @stability stable
     */
    readonly default: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#maximum MonitorAutoscaleSetting#maximum}.
     *
     * @stability stable
     */
    readonly maximum: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#minimum MonitorAutoscaleSetting#minimum}.
     *
     * @stability stable
     */
    readonly minimum: number;
}
export declare function monitorAutoscaleSettingProfileCapacityToTerraform(struct?: MonitorAutoscaleSettingProfileCapacityOutputReference | MonitorAutoscaleSettingProfileCapacity): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingProfileCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingProfileCapacity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingProfileCapacity | undefined);
    private _default?;
    /**
     * @stability stable
     */
    get default(): number;
    /**
     * @stability stable
     */
    set default(value: number);
    /**
     * @stability stable
     */
    get defaultInput(): number | undefined;
    private _maximum?;
    /**
     * @stability stable
     */
    get maximum(): number;
    /**
     * @stability stable
     */
    set maximum(value: number);
    /**
     * @stability stable
     */
    get maximumInput(): number | undefined;
    private _minimum?;
    /**
     * @stability stable
     */
    get minimum(): number;
    /**
     * @stability stable
     */
    set minimum(value: number);
    /**
     * @stability stable
     */
    get minimumInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileFixedDate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#end MonitorAutoscaleSetting#end}.
     *
     * @stability stable
     */
    readonly end: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#start MonitorAutoscaleSetting#start}.
     *
     * @stability stable
     */
    readonly start: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#timezone MonitorAutoscaleSetting#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
}
export declare function monitorAutoscaleSettingProfileFixedDateToTerraform(struct?: MonitorAutoscaleSettingProfileFixedDateOutputReference | MonitorAutoscaleSettingProfileFixedDate): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingProfileFixedDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingProfileFixedDate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingProfileFixedDate | undefined);
    private _end?;
    /**
     * @stability stable
     */
    get end(): string;
    /**
     * @stability stable
     */
    set end(value: string);
    /**
     * @stability stable
     */
    get endInput(): string | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): string;
    /**
     * @stability stable
     */
    set start(value: string);
    /**
     * @stability stable
     */
    get startInput(): string | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#days MonitorAutoscaleSetting#days}.
     *
     * @stability stable
     */
    readonly days: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#hours MonitorAutoscaleSetting#hours}.
     *
     * @stability stable
     */
    readonly hours: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#minutes MonitorAutoscaleSetting#minutes}.
     *
     * @stability stable
     */
    readonly minutes: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#timezone MonitorAutoscaleSetting#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
}
export declare function monitorAutoscaleSettingProfileRecurrenceToTerraform(struct?: MonitorAutoscaleSettingProfileRecurrenceOutputReference | MonitorAutoscaleSettingProfileRecurrence): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingProfileRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingProfileRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingProfileRecurrence | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): string[];
    /**
     * @stability stable
     */
    set days(value: string[]);
    /**
     * @stability stable
     */
    get daysInput(): string[] | undefined;
    private _hours?;
    /**
     * @stability stable
     */
    get hours(): number[];
    /**
     * @stability stable
     */
    set hours(value: number[]);
    /**
     * @stability stable
     */
    get hoursInput(): number[] | undefined;
    private _minutes?;
    /**
     * @stability stable
     */
    get minutes(): number[];
    /**
     * @stability stable
     */
    set minutes(value: number[]);
    /**
     * @stability stable
     */
    get minutesInput(): number[] | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#name MonitorAutoscaleSetting#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#operator MonitorAutoscaleSetting#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#values MonitorAutoscaleSetting#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorAutoscaleSettingProfileRuleMetricTriggerDimensionsToTerraform(struct?: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions): any;
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileRuleMetricTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#divide_by_instance_count MonitorAutoscaleSetting#divide_by_instance_count}.
     *
     * @stability stable
     */
    readonly divideByInstanceCount?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#metric_name MonitorAutoscaleSetting#metric_name}.
     *
     * @stability stable
     */
    readonly metricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#metric_namespace MonitorAutoscaleSetting#metric_namespace}.
     *
     * @stability stable
     */
    readonly metricNamespace?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#metric_resource_id MonitorAutoscaleSetting#metric_resource_id}.
     *
     * @stability stable
     */
    readonly metricResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#operator MonitorAutoscaleSetting#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#statistic MonitorAutoscaleSetting#statistic}.
     *
     * @stability stable
     */
    readonly statistic: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#threshold MonitorAutoscaleSetting#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#time_aggregation MonitorAutoscaleSetting#time_aggregation}.
     *
     * @stability stable
     */
    readonly timeAggregation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#time_grain MonitorAutoscaleSetting#time_grain}.
     *
     * @stability stable
     */
    readonly timeGrain: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#time_window MonitorAutoscaleSetting#time_window}.
     *
     * @stability stable
     */
    readonly timeWindow: string;
    /**
     * dimensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#dimensions MonitorAutoscaleSetting#dimensions}
     *
     * @stability stable
     */
    readonly dimensions?: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[];
}
export declare function monitorAutoscaleSettingProfileRuleMetricTriggerToTerraform(struct?: MonitorAutoscaleSettingProfileRuleMetricTriggerOutputReference | MonitorAutoscaleSettingProfileRuleMetricTrigger): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingProfileRuleMetricTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingProfileRuleMetricTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingProfileRuleMetricTrigger | undefined);
    private _divideByInstanceCount?;
    /**
     * @stability stable
     */
    get divideByInstanceCount(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set divideByInstanceCount(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDivideByInstanceCount(): void;
    /**
     * @stability stable
     */
    get divideByInstanceCountInput(): boolean | cdktf.IResolvable | undefined;
    private _metricName?;
    /**
     * @stability stable
     */
    get metricName(): string;
    /**
     * @stability stable
     */
    set metricName(value: string);
    /**
     * @stability stable
     */
    get metricNameInput(): string | undefined;
    private _metricNamespace?;
    /**
     * @stability stable
     */
    get metricNamespace(): string;
    /**
     * @stability stable
     */
    set metricNamespace(value: string);
    /**
     * @stability stable
     */
    resetMetricNamespace(): void;
    /**
     * @stability stable
     */
    get metricNamespaceInput(): string | undefined;
    private _metricResourceId?;
    /**
     * @stability stable
     */
    get metricResourceId(): string;
    /**
     * @stability stable
     */
    set metricResourceId(value: string);
    /**
     * @stability stable
     */
    get metricResourceIdInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _statistic?;
    /**
     * @stability stable
     */
    get statistic(): string;
    /**
     * @stability stable
     */
    set statistic(value: string);
    /**
     * @stability stable
     */
    get statisticInput(): string | undefined;
    private _threshold?;
    /**
     * @stability stable
     */
    get threshold(): number;
    /**
     * @stability stable
     */
    set threshold(value: number);
    /**
     * @stability stable
     */
    get thresholdInput(): number | undefined;
    private _timeAggregation?;
    /**
     * @stability stable
     */
    get timeAggregation(): string;
    /**
     * @stability stable
     */
    set timeAggregation(value: string);
    /**
     * @stability stable
     */
    get timeAggregationInput(): string | undefined;
    private _timeGrain?;
    /**
     * @stability stable
     */
    get timeGrain(): string;
    /**
     * @stability stable
     */
    set timeGrain(value: string);
    /**
     * @stability stable
     */
    get timeGrainInput(): string | undefined;
    private _timeWindow?;
    /**
     * @stability stable
     */
    get timeWindow(): string;
    /**
     * @stability stable
     */
    set timeWindow(value: string);
    /**
     * @stability stable
     */
    get timeWindowInput(): string | undefined;
    private _dimensions?;
    /**
     * @stability stable
     */
    get dimensions(): MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[];
    /**
     * @stability stable
     */
    set dimensions(value: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[]);
    /**
     * @stability stable
     */
    resetDimensions(): void;
    /**
     * @stability stable
     */
    get dimensionsInput(): MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileRuleScaleAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#cooldown MonitorAutoscaleSetting#cooldown}.
     *
     * @stability stable
     */
    readonly cooldown: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#direction MonitorAutoscaleSetting#direction}.
     *
     * @stability stable
     */
    readonly direction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#type MonitorAutoscaleSetting#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#value MonitorAutoscaleSetting#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function monitorAutoscaleSettingProfileRuleScaleActionToTerraform(struct?: MonitorAutoscaleSettingProfileRuleScaleActionOutputReference | MonitorAutoscaleSettingProfileRuleScaleAction): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingProfileRuleScaleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingProfileRuleScaleAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingProfileRuleScaleAction | undefined);
    private _cooldown?;
    /**
     * @stability stable
     */
    get cooldown(): string;
    /**
     * @stability stable
     */
    set cooldown(value: string);
    /**
     * @stability stable
     */
    get cooldownInput(): string | undefined;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): number;
    /**
     * @stability stable
     */
    set value(value: number);
    /**
     * @stability stable
     */
    get valueInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfileRule {
    /**
     * metric_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#metric_trigger MonitorAutoscaleSetting#metric_trigger}
     *
     * @stability stable
     */
    readonly metricTrigger: MonitorAutoscaleSettingProfileRuleMetricTrigger;
    /**
     * scale_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#scale_action MonitorAutoscaleSetting#scale_action}
     *
     * @stability stable
     */
    readonly scaleAction: MonitorAutoscaleSettingProfileRuleScaleAction;
}
export declare function monitorAutoscaleSettingProfileRuleToTerraform(struct?: MonitorAutoscaleSettingProfileRule): any;
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#name MonitorAutoscaleSetting#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#capacity MonitorAutoscaleSetting#capacity}
     *
     * @stability stable
     */
    readonly capacity: MonitorAutoscaleSettingProfileCapacity;
    /**
     * fixed_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#fixed_date MonitorAutoscaleSetting#fixed_date}
     *
     * @stability stable
     */
    readonly fixedDate?: MonitorAutoscaleSettingProfileFixedDate;
    /**
     * recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#recurrence MonitorAutoscaleSetting#recurrence}
     *
     * @stability stable
     */
    readonly recurrence?: MonitorAutoscaleSettingProfileRecurrence;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#rule MonitorAutoscaleSetting#rule}
     *
     * @stability stable
     */
    readonly rule?: MonitorAutoscaleSettingProfileRule[];
}
export declare function monitorAutoscaleSettingProfileToTerraform(struct?: MonitorAutoscaleSettingProfile): any;
/**
 * @stability stable
 */
export interface MonitorAutoscaleSettingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#create MonitorAutoscaleSetting#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#delete MonitorAutoscaleSetting#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#read MonitorAutoscaleSetting#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html#update MonitorAutoscaleSetting#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorAutoscaleSettingTimeoutsToTerraform(struct?: MonitorAutoscaleSettingTimeoutsOutputReference | MonitorAutoscaleSettingTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorAutoscaleSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAutoscaleSettingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAutoscaleSettingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html azurerm_monitor_autoscale_setting}.
 *
 * @stability stable
 */
export declare class MonitorAutoscaleSetting extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_autoscale_setting.html azurerm_monitor_autoscale_setting} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorAutoscaleSettingConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _notification;
    /**
     * @stability stable
     */
    get notification(): MonitorAutoscaleSettingNotificationOutputReference;
    /**
     * @stability stable
     */
    putNotification(value: MonitorAutoscaleSettingNotification): void;
    /**
     * @stability stable
     */
    resetNotification(): void;
    /**
     * @stability stable
     */
    get notificationInput(): MonitorAutoscaleSettingNotification | undefined;
    private _profile?;
    /**
     * @stability stable
     */
    get profile(): MonitorAutoscaleSettingProfile[];
    /**
     * @stability stable
     */
    set profile(value: MonitorAutoscaleSettingProfile[]);
    /**
     * @stability stable
     */
    get profileInput(): MonitorAutoscaleSettingProfile[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorAutoscaleSettingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorAutoscaleSettingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorAutoscaleSettingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
