from dataclasses import dataclass
from enum import Enum
from typing import NamedTuple

__all__ = ["Specificity", "Result", "Level", "Position", "SpecificityContributingPart"]


class Level(str, Enum):
    A = "A"
    B = "B"
    C = "C"


class Position(NamedTuple):
    line: int
    column: int


@dataclass
class SpecificityContributingPart:
    level: Level
    start: Position
    end: Position


Specificity = dict[Level, int]


@dataclass
class Result:
    total: Specificity
    contributing_parts: list[SpecificityContributingPart]
