"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticachememcached = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("../../core");
const constructs_1 = require("constructs");
const core_1 = require("../../core");
const defaultEnvironmentVariableName = "CACHE_ENDPOINT";
/**
 * @summary The LambdaToElasticachememcached class.
 */
class LambdaToElasticachememcached extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if ((props.existingCache || props.existingLambdaObj) && (!props.existingVpc)) {
            throw Error('If providing an existing Cache or Lambda Function, you must also supply the associated existingVpc');
        }
        if (props.cacheProps &&
            props.cacheProps.engine &&
            props.cacheProps.engine !== "memcached") {
            throw Error("This construct can only launch memcached clusters");
        }
        if (props.cacheProps && props.existingCache) {
            throw Error("Cannot specify existingCache and cacheProps");
        }
        const cachePort = core_1.getCachePort(props.cacheProps, props.existingCache);
        this.vpc = defaults.buildVpc(scope, {
            defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
            existingVpc: props.existingVpc,
            userVpcProps: props.vpcProps,
        });
        const lambdaToCacheSecurityGroup = core_1.CreateSelfReferencingSecurityGroup(this, id, this.vpc, cachePort);
        this.cache = core_1.obtainMemcachedCluster(this, id, {
            cacheSecurityGroupId: lambdaToCacheSecurityGroup.securityGroupId,
            cacheProps: props.cacheProps,
            existingCache: props.existingCache,
            vpc: this.vpc,
            cachePort,
        });
        // Add the self-referencing security group to the Lambda function props
        const lambdaFunctionProps = defaults.consolidateProps({}, props.lambdaFunctionProps, { securityGroups: [lambdaToCacheSecurityGroup] }, true);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps,
            vpc: this.vpc,
        });
        AddLambdaEnvironmentVariable(this.lambdaFunction, `${this.cache.attrConfigurationEndpointAddress}:${this.cache.attrConfigurationEndpointPort}`, defaultEnvironmentVariableName, props.cacheEndpointEnvironmentVariableName);
    }
}
exports.LambdaToElasticachememcached = LambdaToElasticachememcached;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticachememcached[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticachememcached.LambdaToElasticachememcached", version: "2.43.0" };
function AddLambdaEnvironmentVariable(targetFunction, value, defaultName, clientName) {
    const variableName = clientName || defaultName;
    targetFunction.addEnvironment(variableName, value);
}
//# sourceMappingURL=data:application/json;base64,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