/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.BaseNFeature;
import category_encoders.CategoryEncoder;
import category_encoders.OrdinalEncoder;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;

public class BaseNEncoder
extends CategoryEncoder {
    public BaseNEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Integer base = this.getBase();
        List<?> cols = this.getCols();
        List<String> dropCols = null;
        Boolean dropInvariant = this.getDropInvariant();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        OrdinalEncoder ordinalEncoder = this.getOrdinalEncoder();
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException(Integer.toString(base));
        }
        if (dropInvariant.booleanValue()) {
            dropCols = this.getDropCols();
        }
        Object missingCategory = null;
        switch (handleMissing) {
            case "error": {
                break;
            }
            case "value": {
                missingCategory = CategoryEncoder.CATEGORY_NAN;
                break;
            }
            default: {
                throw new IllegalArgumentException(handleMissing);
            }
        }
        switch (handleUnknown) {
            case "error": {
                break;
            }
            default: {
                throw new IllegalArgumentException(handleUnknown);
            }
        }
        List<OrdinalEncoder.Mapping> ordinalMappings = ordinalEncoder.getMapping();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, cols, ordinalMappings});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Object col = cols.get(i);
            OrdinalEncoder.Mapping ordinalMapping = ordinalMappings.get(i);
            Map<?, Integer> ordinalCategoryMappings = ordinalMapping.getCategoryMapping();
            int requiredDigits = BaseNEncoder.calcRequiredDigits(ordinalCategoryMappings, base);
            Map<Object, String> baseCategoryMappings = BaseNEncoder.baseEncodeValues(ordinalCategoryMappings, base, requiredDigits);
            ArrayList<BaseNFeature> baseFeatures = new ArrayList<BaseNFeature>();
            for (int pos = 0; pos < requiredDigits; ++pos) {
                String dropCol = String.valueOf(col) + "_" + String.valueOf(pos);
                if (dropCols != null && dropCols.contains(dropCol)) continue;
                LinkedHashMultimap values = LinkedHashMultimap.create();
                Set<Map.Entry<Object, String>> entries = baseCategoryMappings.entrySet();
                for (Map.Entry entry : entries) {
                    Object category = entry.getKey();
                    String baseValue = (String)entry.getValue();
                    char digit = baseValue.charAt(pos);
                    values.put((Object)Character.getNumericValue(digit), category);
                }
                BaseNFeature baseFeature = new BaseNFeature((PMMLEncoder)encoder, feature, (int)base, pos, (SetMultimap<Integer, ?>)values, missingCategory);
                baseFeatures.add(baseFeature);
            }
            result.addAll(baseFeatures);
        }
        return result;
    }

    public Integer getBase() {
        return this.getInteger("base");
    }

    public OrdinalEncoder getOrdinalEncoder() {
        return (OrdinalEncoder)this.get("ordinal_encoder", OrdinalEncoder.class);
    }

    private static int calcRequiredDigits(Map<?, Integer> ordinalCategoryMappings, int base) {
        if (base == 1) {
            return ordinalCategoryMappings.size() + 1;
        }
        return (int)Math.ceil(Math.log(ordinalCategoryMappings.size()) / Math.log(base)) + 1;
    }

    public static Map<Object, String> baseEncodeValues(Map<?, Integer> categoryMappings, int base, int requiredDigits) {
        LinkedHashMap<Object, String> result = new LinkedHashMap<Object, String>();
        Set<Map.Entry<?, Integer>> entries = categoryMappings.entrySet();
        for (Map.Entry entry : entries) {
            String baseValue = Strings.padStart((String)Integer.toString((Integer)entry.getValue(), base), (int)requiredDigits, (char)'0');
            result.put(entry.getKey(), baseValue);
        }
        return result;
    }
}

