/*
 * Decompiled with CFR 0.152.
 */
package sklearn.naive_bayes;

import java.util.Collection;
import java.util.List;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.DataType;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.BayesOutput;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.dmg.pmml.naive_bayes.TargetValueStat;
import org.dmg.pmml.naive_bayes.TargetValueStats;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.python.ClassDictUtil;
import sklearn.Classifier;

public class GaussianNB
extends Classifier {
    public GaussianNB(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getThetaShape();
        return shape[1];
    }

    public NaiveBayesModel encodeModel(Schema schema) {
        int[] shape = this.getThetaShape();
        int numberOfClasses = shape[0];
        int numberOfFeatures = shape[1];
        List<? extends Number> theta = this.getTheta();
        List<? extends Number> sigma = this.getSigma();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        BayesInputs bayesInputs = new BayesInputs();
        for (int i = 0; i < numberOfFeatures; ++i) {
            Feature feature = schema.getFeature(i);
            List means = CMatrixUtil.getColumn(theta, (int)numberOfClasses, (int)numberOfFeatures, (int)i);
            List variances = CMatrixUtil.getColumn(sigma, (int)numberOfClasses, (int)numberOfFeatures, (int)i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            BayesInput bayesInput = new BayesInput(continuousFeature.getName(), GaussianNB.encodeTargetValueStats(categoricalLabel.getValues(), means, variances), null);
            bayesInputs.addBayesInputs(new BayesInput[]{bayesInput});
        }
        List<Integer> classCount = this.getClassCount();
        BayesOutput bayesOutput = new BayesOutput(categoricalLabel.getName(), null).setTargetValueCounts(GaussianNB.encodeTargetValueCounts(categoricalLabel.getValues(), classCount));
        NaiveBayesModel naiveBayesModel = new NaiveBayesModel((Number)0.0, MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), bayesInputs, bayesOutput).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel));
        return naiveBayesModel;
    }

    public List<Integer> getClassCount() {
        return this.getIntegerArray("class_count_");
    }

    public List<? extends Number> getTheta() {
        return this.getNumberArray("theta_");
    }

    public int[] getThetaShape() {
        return this.getArrayShape("theta_", 2);
    }

    public List<? extends Number> getSigma() {
        return this.getNumberArray("sigma_");
    }

    private static TargetValueStats encodeTargetValueStats(List<?> values, List<? extends Number> means, List<? extends Number> variances) {
        TargetValueStats targetValueStats = new TargetValueStats();
        ClassDictUtil.checkSize((Collection[])new Collection[]{values, means, variances});
        for (int i = 0; i < values.size(); ++i) {
            GaussianDistribution gaussianDistribution = new GaussianDistribution(means.get(i), variances.get(i));
            TargetValueStat targetValueStat = new TargetValueStat(values.get(i), (ContinuousDistribution)gaussianDistribution);
            targetValueStats.addTargetValueStats(new TargetValueStat[]{targetValueStat});
        }
        return targetValueStats;
    }

    private static TargetValueCounts encodeTargetValueCounts(List<?> values, List<Integer> counts) {
        TargetValueCounts targetValueCounts = new TargetValueCounts();
        ClassDictUtil.checkSize((Collection[])new Collection[]{values, counts});
        for (int i = 0; i < values.size(); ++i) {
            TargetValueCount targetValueCount = new TargetValueCount(values.get(i), (Number)counts.get(i));
            targetValueCounts.addTargetValueCounts(new TargetValueCount[]{targetValueCount});
        }
        return targetValueCounts;
    }
}

