/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.StepUtil;
import sklearn2pmml.decoration.Domain;

public abstract class DiscreteDomain
extends Domain {
    public DiscreteDomain(String module, String name) {
        super(module, name);
    }

    public abstract Feature encodeFeature(WildcardFeature var1, List<?> var2);

    @Override
    public int getNumberOfFeatures() {
        return 1;
    }

    @Override
    public DataType getDataType() {
        Object dtype = this.getDType();
        Boolean withData = this.getWithData();
        if (dtype != null) {
            return StepUtil.getDataType(dtype);
        }
        if (withData.booleanValue()) {
            List<?> data = this.getData();
            return TypeUtil.getDataType(data, (DataType)DataType.STRING);
        }
        return DataType.STRING;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        features = super.encodeFeatures(features, encoder);
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        WildcardFeature wildcardFeature = DiscreteDomain.asWildcardFeature(feature);
        if (withData.booleanValue()) {
            List<?> data = this.getData();
            feature = this.encodeFeature(wildcardFeature, data);
        } else {
            feature = this.encodeFeature(wildcardFeature, Collections.emptyList());
        }
        if (withStatistics.booleanValue()) {
            Map<String, ?> counts = DiscreteDomain.extractMap(this.getCounts(), 0);
            Object[] discrStats = this.getDiscrStats();
            UnivariateStats univariateStats = new UnivariateStats().setField(wildcardFeature.getName()).setCounts(DiscreteDomain.createCounts(counts)).setDiscrStats(DiscreteDomain.createDiscrStats(wildcardFeature.getDataType(), discrStats));
            encoder.putUnivariateStats(univariateStats);
        }
        return Collections.singletonList(feature);
    }

    public List<?> getData() {
        return this.getArray("data_");
    }

    public Object[] getDiscrStats() {
        return this.getTuple("discr_stats_");
    }

    public static DiscrStats createDiscrStats(DataType dataType, Object[] objects) {
        List<?> values = DiscreteDomain.asArray(objects[0]);
        List counts = ValueUtil.asIntegers(DiscreteDomain.asArray(objects[1]));
        ClassDictUtil.checkSize((Collection[])new Collection[]{values, counts});
        DiscrStats discrStats = new DiscrStats().addArrays(new Array[]{PMMLUtil.createStringArray(DiscreteDomain.standardizeValues(dataType, values)), PMMLUtil.createIntArray((List)counts)});
        return discrStats;
    }
}

