/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.jpmml.xgboost.GBTree;
import org.jpmml.xgboost.JSONUtil;
import org.jpmml.xgboost.XGBoostDataInput;

public class Dart
extends GBTree {
    private float[] weight_drop;

    @Override
    public String getAlgorithmName() {
        return "DART";
    }

    @Override
    public void loadBinary(XGBoostDataInput input) throws IOException {
        super.loadBinary(input);
        int num_trees = this.num_trees();
        if (num_trees != 0) {
            this.weight_drop = input.readFloatVector();
        }
    }

    @Override
    public void loadJSON(JsonObject gradientBooster) {
        JsonObject gbtree = gradientBooster.getAsJsonObject("gbtree");
        super.loadJSON(gbtree);
        JsonArray weightDrop = gradientBooster.getAsJsonArray("weight_drop");
        this.weight_drop = JSONUtil.toFloatArray(weightDrop);
    }

    @Override
    public float[] tree_weights() {
        return this.weight_drop;
    }
}

