/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.gson.JsonObject;
import org.jpmml.xgboost.JSONLoadable;
import org.jpmml.xgboost.Node;

public class JSONNode
extends Node
implements JSONLoadable {
    private int parent;
    private int left_child;
    private int right_child;
    private boolean default_left;
    private int split_index;
    private float split_condition;

    @Override
    public void loadJSON(JsonObject node) {
        this.parent = node.getAsJsonPrimitive("parent").getAsInt();
        this.left_child = node.getAsJsonPrimitive("left_child").getAsInt();
        this.right_child = node.getAsJsonPrimitive("right_child").getAsInt();
        this.default_left = node.getAsJsonPrimitive("default_left").getAsBoolean();
        this.split_index = node.getAsJsonPrimitive("split_index").getAsInt();
        this.split_condition = node.getAsJsonPrimitive("split_condition").getAsFloat();
    }

    @Override
    public boolean is_leaf() {
        return this.left_child == -1;
    }

    @Override
    public int left_child() {
        return this.left_child;
    }

    @Override
    public int right_child() {
        return this.right_child;
    }

    @Override
    public boolean default_left() {
        return this.default_left;
    }

    @Override
    public int split_index() {
        return this.split_index;
    }

    @Override
    public int split_cond() {
        return Float.floatToIntBits(this.split_condition);
    }

    @Override
    public float leaf_value() {
        return this.split_condition;
    }
}

