/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.python.Scope;

public class BlockScope
extends Scope {
    private List<? extends Feature> variables = null;

    public BlockScope(List<? extends Feature> variables) {
        this.setVariables(variables);
    }

    @Override
    public Feature getFeature(FieldName name) {
        List<? extends Feature> features = this.getVariables();
        for (Feature feature2 : features) {
            if (!feature2.getName().equals((Object)name)) continue;
            return feature2;
        }
        List variableNames = features.stream().map(feature -> "'" + feature.getName().getValue() + "'").collect(Collectors.toList());
        throw new IllegalArgumentException("Name '" + name.getValue() + "' is not in " + variableNames);
    }

    @Override
    public Feature getFeature(FieldName name, int columnIndex) {
        this.getFeature(name);
        throw new IllegalArgumentException("Name '" + name.getValue() + "' is not subscriptable");
    }

    @Override
    public Feature getFeature(FieldName name, FieldName columnName) {
        this.getFeature(name);
        throw new IllegalArgumentException("Name '" + name.getValue() + "' is not subscriptable");
    }

    @Override
    public Feature resolveFeature(FieldName name) {
        List<? extends Feature> features = this.getVariables();
        for (Feature feature : features) {
            if (!feature.getName().equals((Object)name)) continue;
            return feature;
        }
        return null;
    }

    public List<? extends Feature> getVariables() {
        return this.variables;
    }

    private void setVariables(List<? extends Feature> variables) {
        this.variables = Objects.requireNonNull(variables);
    }
}

