/**
 * Enable sourcemaps for Jasmine exception output.
 *
 * This will locate any stack traces outputted by Jasmine as the result of
 * unit test failures and run the stack traces through the third-party
 * sourcemapped-stacktrace.js. This allows for debugging code generated by
 * Babel, CoffeeScript, and others.
 *
 * Copyright (C) 2016 Beanbag, Inc.
 *
 * Licensed under the MIT license.
 */
(function() {


function mapStackTrace(traceEl) {
    sourceMappedStackTrace.mapStackTrace(
        traceEl.textContent,
        function(stack) {
            traceEl.textContent = traceEl.previousSibling.textContent +
                                  '\n' + stack.join('\n');
        });
}


window.addEventListener('DOMContentLoaded', function() {
    jasmine.getEnv().addReporter({
        jasmineDone: function() {
            var traces = document.querySelectorAll('.jasmine-stack-trace'),
                i;

            for (i = 0; i < traces.length; i++) {
                mapStackTrace(traces[i]);
            }
        }
    });
});


})();
