import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeFileFormatsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats#database DataSnowflakeFileFormats#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the file formats from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats#schema DataSnowflakeFileFormats#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeFileFormatsFileFormats extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get formatType(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats snowflake_file_formats}
*/
export declare class DataSnowflakeFileFormats extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats snowflake_file_formats} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeFileFormatsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeFileFormatsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    fileFormats(index: string): DataSnowflakeFileFormatsFileFormats;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
