import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeProceduresConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/procedures#database DataSnowflakeProcedures#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the procedures from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/procedures#schema DataSnowflakeProcedures#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeProceduresProcedures extends cdktf.ComplexComputedList {
    get argumentTypes(): string[];
    get comment(): string;
    get database(): string;
    get name(): string;
    get returnType(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/procedures snowflake_procedures}
*/
export declare class DataSnowflakeProcedures extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/procedures snowflake_procedures} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeProceduresConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeProceduresConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    procedures(index: string): DataSnowflakeProceduresProcedures;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
