import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeRowAccessPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies#database DataSnowflakeRowAccessPolicies#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the row access policyfrom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies#schema DataSnowflakeRowAccessPolicies#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeRowAccessPoliciesRowAccessPolicies extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies snowflake_row_access_policies}
*/
export declare class DataSnowflakeRowAccessPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies snowflake_row_access_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeRowAccessPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeRowAccessPoliciesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    rowAccessPolicies(index: string): DataSnowflakeRowAccessPoliciesRowAccessPolicies;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
