import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleGrantsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the role we are granting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants#role_name RoleGrants#role_name}
    */
    readonly roleName: string;
    /**
    * Grants role to this specified role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants#roles RoleGrants#roles}
    */
    readonly roles?: string[];
    /**
    * Grants role to this specified user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants#users RoleGrants#users}
    */
    readonly users?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants snowflake_role_grants}
*/
export declare class RoleGrants extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants snowflake_role_grants} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleGrantsConfig
    */
    constructor(scope: Construct, id: string, config: RoleGrantsConfig);
    get id(): string;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _users?;
    get users(): string[];
    set users(value: string[]);
    resetUsers(): void;
    get usersInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
