# 🛡️ Watchman Agent

## 🔍 Overview

**Watchman Agent** is a lightweight and flexible CLI tool designed to **monitor network and stack activity**, and **automate system reporting**. It can be deployed across environments to ensure seamless visibility and vulnerability tracking.

This repository contains the CLI source code, installation guide, and usage instructions for integrating Watchman Agent into your infrastructure.

👉 Full documentation available at: [**docs.watchman.bj**](https://docs.watchman.bj)

---

## 🚀 Installation

Install the latest version from PyPI:

```bash
pip install watchman-agent
```

---

## 🛠️ Run Command

To start the monitoring process and attach it to a cron job:

```bash
watchman-agent run
```

This command launches the agent and executes the configured checks and actions (e.g., software inventory, stack changes, vulnerability detection).

---

## 🔄 Upgrade Watchman Agent

Keep your CLI up to date with:

```bash
pip install --upgrade watchman-agent
```

---

## 📘 Documentation

For a complete guide including advanced usage, authentication setup, API integration, and troubleshooting, visit:

🌐 [https://docs.watchman.bj](https://docs.watchman.bj)

---

## 🔐 Terms and Usage

By using Watchman Agent, you agree to the [terms of service](https://watchman.bj/terms-conditions) and privacy policy outlined by GLOBAL IT SERVICE SARL. The agent is designed to be used within the legal framework of your organization and must not be deployed for unauthorized surveillance.
