from setuptools import setup, find_packages

with open("Readme.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()
    
setup(
    name="watchman-agent",
    version="3.0.5",
    author="Watchman",
    author_email="support@watchman.bj",
    # description = "Watchman Agent 1.0.0",
    description='Agent pour collecter des informations système et les envoyer à une API centrale.',
    long_description=long_description,
    long_description_content_type='text/markdown',
    include_package_data=True,
    packages=find_packages(),
    python_requires='>=3.8',
    # py_modules=[''],
    # install_requires=[
    #     'requests',
    #     'sqlitedict',
    #     'scapy',
    #     'keyring',
    #     'python-crontab',
    #     'environs',
    #     'click',
    #     'sqlitedict',
    #     'paramiko',
    #     'pyyaml',
    #     'schedule',
    #     'pysnmplib',
    #     'semver',
    #     'packaging',
    #     'openpyxl',
    #     # 'pandas',
    #     'getmac',
    #     'platformdirs',
    # ],
    install_requires=[
        "altgraph==0.17.4",
        "anyio==4.9.0",
        "APScheduler==3.11.0",
        "bcrypt==4.3.0",
        "blinker==1.9.0",
        "certifi==2025.1.31",
        "cffi==1.17.1",
        "charset-normalizer==3.4.1",
        "click==8.1.7",
        "colorama==0.4.6",
        "cryptography==44.0.2",
        "Cython==3.0.7",
        "environs==10.0.0",
        "et_xmlfile==2.0.0",
        "getmac==0.9.4",
        "h11==0.14.0",
        "httpcore==1.0.8",
        "httpx==0.28.1",
        "idna==3.10",
        "jaraco.classes==3.4.0",
        "keyring==24.3.0",
        "ldap3==2.9.1",
        "marshmallow==3.26.1",
        "more-itertools==10.6.0",
        "openpyxl==3.1.5",
        "packaging==23.2",
        "paramiko==3.4.0",
        "pefile==2024.8.26",
        "platformdirs==4.1.0",
        "ply==3.11",
        "psutil==7.0.0",
        "puresnmp==2.0.1",
        "pyasn1==0.6.1",
        "pycparser==2.22",
        "pycryptodomex==3.22.0",
        "pyinstaller==6.3.0",
        "pyinstaller-hooks-contrib==2025.2",
        "PyNaCl==1.5.0",
        "pysnmp-pyasn1==1.1.3",
        "pysnmp-pysmi==1.1.12",
        "pysnmplib==5.0.23",
        "pyspnego==0.11.2",
        "python-crontab==3.0.0",
        "python-dateutil==2.9.0.post0",
        "python-dotenv==1.1.0",
        "python-magic==0.4.27",
        "python-magic-bin==0.4.14 ; sys_platform == 'win32'",
        "pywin32-ctypes==0.2.3",
        "pywinrm==0.5.0",
        "PyYAML==6.0.1",
        "requests==2.31.0",
        "requests-toolbelt==1.0.0",
        "requests_ntlm==1.3.0",
        "scapy==2.5.0",
        "schedule==1.2.1",
        "semver==3.0.2",
        "setuptools==69.0.2",
        "six==1.17.0",
        "sniffio==1.3.1",
        "sqlitedict==2.1.0",
        "t61codec==1.0.1",
        "typing_extensions==4.12.2",
        "tzlocal==5.3.1",
        "urllib3==2.3.0",
        "Werkzeug==3.1.3",
        "WMI==1.4.9",
        "x690==1.0.0.post1",
        "xmltodict==0.14.2",
        "zipp==3.21.0",
        "wmi==1.4.9 ; sys_platform == 'win32'"
    ],

    entry_points='''
        [console_scripts]
        watchman-agent=watchman_agent_v2.agent:cli
    '''
)
