# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiValidationResult',
    'AwaitableGetApiValidationResult',
    'get_api_validation',
    'get_api_validation_output',
]

@pulumi.output_type
class GetApiValidationResult:
    """
    A collection of values returned by getApiValidation.
    """
    def __init__(__self__, api_id=None, id=None, validations=None):
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if validations and not isinstance(validations, list):
            raise TypeError("Expected argument 'validations' to be a list")
        pulumi.set(__self__, "validations", validations)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> str:
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def validations(self) -> Sequence['outputs.GetApiValidationValidationResult']:
        """
        API validation results.
        """
        return pulumi.get(self, "validations")


class AwaitableGetApiValidationResult(GetApiValidationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiValidationResult(
            api_id=self.api_id,
            id=self.id,
            validations=self.validations)


def get_api_validation(api_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiValidationResult:
    """
    This data source provides details about a specific Api Validation resource in Oracle Cloud Infrastructure API Gateway service.

    Gets the API validation results.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_validation = oci.ApiGateway.get_api_validation(api_id=test_api["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getApiValidation:getApiValidation', __args__, opts=opts, typ=GetApiValidationResult).value

    return AwaitableGetApiValidationResult(
        api_id=pulumi.get(__ret__, 'api_id'),
        id=pulumi.get(__ret__, 'id'),
        validations=pulumi.get(__ret__, 'validations'))


@_utilities.lift_output_func(get_api_validation)
def get_api_validation_output(api_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApiValidationResult]:
    """
    This data source provides details about a specific Api Validation resource in Oracle Cloud Infrastructure API Gateway service.

    Gets the API validation results.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_validation = oci.ApiGateway.get_api_validation(api_id=test_api["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str api_id: The ocid of the API.
    """
    ...
