# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[str],
                 config_type: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]] = None,
                 filter_id: Optional[pulumi.Input[str]] = None,
                 filter_text: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 opc_dry_run: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A description of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]] rules: (Updatable)
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        pulumi.set(__self__, "config_type", config_type)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if filter_id is not None:
            pulumi.set(__self__, "filter_id", filter_id)
        if filter_text is not None:
            pulumi.set(__self__, "filter_text", filter_text)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if in_use_bies is not None:
            pulumi.set(__self__, "in_use_bies", in_use_bies)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A description of the metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]:
        """
        (Updatable) A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @filter_id.setter
    def filter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_id", value)

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @filter_text.setter
    def filter_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_text", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @in_use_bies.setter
    def in_use_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]):
        pulumi.set(self, "in_use_bies", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]:
        """
        (Updatable) The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opc_dry_run", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 config_type: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 filter_id: Optional[pulumi.Input[str]] = None,
                 filter_text: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 opc_dry_run: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 updated_by: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A description of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[str] etag: For optimistic concurrency control. See `if-match`.
        :param pulumi.Input[str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]] rules: (Updatable)
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[str] updated_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        if apm_domain_id is not None:
            pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if filter_id is not None:
            pulumi.set(__self__, "filter_id", filter_id)
        if filter_text is not None:
            pulumi.set(__self__, "filter_text", filter_text)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if in_use_bies is not None:
            pulumi.set(__self__, "in_use_bies", in_use_bies)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A description of the metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]:
        """
        (Updatable) A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @filter_id.setter
    def filter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_id", value)

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @filter_text.setter
    def filter_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_text", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @in_use_bies.setter
    def in_use_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]):
        pulumi.set(self, "in_use_bies", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]:
        """
        (Updatable) The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opc_dry_run", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_by", value)


class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 config_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigDimensionArgs']]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filter_id: Optional[pulumi.Input[str]] = None,
                 filter_text: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigInUseByArgs']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigMetricArgs']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 opc_dry_run: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigRuleArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Config resource in Oracle Cloud Infrastructure Apm Config service.

        Creates a new configuration item.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_config = oci.apm_config.Config("test_config",
            apm_domain_id=test_apm_domain["id"],
            config_type=config_config_type,
            display_name=config_display_name,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=config_description,
            dimensions=[oci.apm_config.ConfigDimensionArgs(
                name=config_dimensions_name,
                value_source=config_dimensions_value_source,
            )],
            filter_id=test_filter["id"],
            filter_text=config_filter_text,
            freeform_tags={
                "bar-key": "value",
            },
            group=config_group,
            metrics=[oci.apm_config.ConfigMetricArgs(
                description=config_metrics_description,
                name=config_metrics_name,
                unit=config_metrics_unit,
                value_source=config_metrics_value_source,
            )],
            namespace=config_namespace,
            opc_dry_run=config_opc_dry_run,
            options=config_options,
            rules=[oci.apm_config.ConfigRuleArgs(
                display_name=config_rules_display_name,
                filter_text=config_rules_filter_text,
                is_apply_to_error_spans=config_rules_is_apply_to_error_spans,
                is_enabled=config_rules_is_enabled,
                priority=config_rules_priority,
                satisfied_response_time=config_rules_satisfied_response_time,
                tolerating_response_time=config_rules_tolerating_response_time,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Configs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmConfig/config:Config test_config "configs/{configId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A description of the metric.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigDimensionArgs']]]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigInUseByArgs']]]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigMetricArgs']]]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigRuleArgs']]]] rules: (Updatable)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Config resource in Oracle Cloud Infrastructure Apm Config service.

        Creates a new configuration item.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_config = oci.apm_config.Config("test_config",
            apm_domain_id=test_apm_domain["id"],
            config_type=config_config_type,
            display_name=config_display_name,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=config_description,
            dimensions=[oci.apm_config.ConfigDimensionArgs(
                name=config_dimensions_name,
                value_source=config_dimensions_value_source,
            )],
            filter_id=test_filter["id"],
            filter_text=config_filter_text,
            freeform_tags={
                "bar-key": "value",
            },
            group=config_group,
            metrics=[oci.apm_config.ConfigMetricArgs(
                description=config_metrics_description,
                name=config_metrics_name,
                unit=config_metrics_unit,
                value_source=config_metrics_value_source,
            )],
            namespace=config_namespace,
            opc_dry_run=config_opc_dry_run,
            options=config_options,
            rules=[oci.apm_config.ConfigRuleArgs(
                display_name=config_rules_display_name,
                filter_text=config_rules_filter_text,
                is_apply_to_error_spans=config_rules_is_apply_to_error_spans,
                is_enabled=config_rules_is_enabled,
                priority=config_rules_priority,
                satisfied_response_time=config_rules_satisfied_response_time,
                tolerating_response_time=config_rules_tolerating_response_time,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Configs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmConfig/config:Config test_config "configs/{configId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 config_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigDimensionArgs']]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filter_id: Optional[pulumi.Input[str]] = None,
                 filter_text: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigInUseByArgs']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigMetricArgs']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 opc_dry_run: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            if config_type is None and not opts.urn:
                raise TypeError("Missing required property 'config_type'")
            __props__.__dict__["config_type"] = config_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["dimensions"] = dimensions
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["filter_id"] = filter_id
            __props__.__dict__["filter_text"] = filter_text
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["group"] = group
            __props__.__dict__["in_use_bies"] = in_use_bies
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["opc_dry_run"] = opc_dry_run
            __props__.__dict__["options"] = options
            __props__.__dict__["rules"] = rules
            __props__.__dict__["created_by"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["updated_by"] = None
        super(Config, __self__).__init__(
            'oci:ApmConfig/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apm_domain_id: Optional[pulumi.Input[str]] = None,
            config_type: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigDimensionArgs']]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            filter_id: Optional[pulumi.Input[str]] = None,
            filter_text: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            group: Optional[pulumi.Input[str]] = None,
            in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigInUseByArgs']]]]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigMetricArgs']]]]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            opc_dry_run: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigRuleArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            updated_by: Optional[pulumi.Input[str]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A description of the metric.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigDimensionArgs']]]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[str] etag: For optimistic concurrency control. See `if-match`.
        :param pulumi.Input[str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigInUseByArgs']]]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigMetricArgs']]]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigRuleArgs']]]] rules: (Updatable)
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[str] updated_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["filter_id"] = filter_id
        __props__.__dict__["filter_text"] = filter_text
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group"] = group
        __props__.__dict__["in_use_bies"] = in_use_bies
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["opc_dry_run"] = opc_dry_run
        __props__.__dict__["options"] = options
        __props__.__dict__["rules"] = rules
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["updated_by"] = updated_by
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Sequence['outputs.ConfigDimension']]:
        """
        (Updatable) A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> pulumi.Output[str]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[str]:
        """
        (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> pulumi.Output[Sequence['outputs.ConfigInUseBy']]:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.ConfigMetric']]:
        """
        (Updatable) The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> pulumi.Output[str]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[str]:
        """
        (Updatable) The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.ConfigRule']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "updated_by")

