# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMonitorResult',
    'AwaitableGetMonitorResult',
    'get_monitor',
    'get_monitor_output',
]

@pulumi.output_type
class GetMonitorResult:
    """
    A collection of values returned by getMonitor.
    """
    def __init__(__self__, apm_domain_id=None, availability_configurations=None, batch_interval_in_seconds=None, configurations=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_run_now=None, is_run_once=None, maintenance_window_schedules=None, monitor_id=None, monitor_type=None, repeat_interval_in_seconds=None, scheduling_policy=None, script_id=None, script_name=None, script_parameters=None, status=None, target=None, time_created=None, time_updated=None, timeout_in_seconds=None, vantage_point_count=None, vantage_points=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if availability_configurations and not isinstance(availability_configurations, list):
            raise TypeError("Expected argument 'availability_configurations' to be a list")
        pulumi.set(__self__, "availability_configurations", availability_configurations)
        if batch_interval_in_seconds and not isinstance(batch_interval_in_seconds, int):
            raise TypeError("Expected argument 'batch_interval_in_seconds' to be a int")
        pulumi.set(__self__, "batch_interval_in_seconds", batch_interval_in_seconds)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_run_now and not isinstance(is_run_now, bool):
            raise TypeError("Expected argument 'is_run_now' to be a bool")
        pulumi.set(__self__, "is_run_now", is_run_now)
        if is_run_once and not isinstance(is_run_once, bool):
            raise TypeError("Expected argument 'is_run_once' to be a bool")
        pulumi.set(__self__, "is_run_once", is_run_once)
        if maintenance_window_schedules and not isinstance(maintenance_window_schedules, list):
            raise TypeError("Expected argument 'maintenance_window_schedules' to be a list")
        pulumi.set(__self__, "maintenance_window_schedules", maintenance_window_schedules)
        if monitor_id and not isinstance(monitor_id, str):
            raise TypeError("Expected argument 'monitor_id' to be a str")
        pulumi.set(__self__, "monitor_id", monitor_id)
        if monitor_type and not isinstance(monitor_type, str):
            raise TypeError("Expected argument 'monitor_type' to be a str")
        pulumi.set(__self__, "monitor_type", monitor_type)
        if repeat_interval_in_seconds and not isinstance(repeat_interval_in_seconds, int):
            raise TypeError("Expected argument 'repeat_interval_in_seconds' to be a int")
        pulumi.set(__self__, "repeat_interval_in_seconds", repeat_interval_in_seconds)
        if scheduling_policy and not isinstance(scheduling_policy, str):
            raise TypeError("Expected argument 'scheduling_policy' to be a str")
        pulumi.set(__self__, "scheduling_policy", scheduling_policy)
        if script_id and not isinstance(script_id, str):
            raise TypeError("Expected argument 'script_id' to be a str")
        pulumi.set(__self__, "script_id", script_id)
        if script_name and not isinstance(script_name, str):
            raise TypeError("Expected argument 'script_name' to be a str")
        pulumi.set(__self__, "script_name", script_name)
        if script_parameters and not isinstance(script_parameters, list):
            raise TypeError("Expected argument 'script_parameters' to be a list")
        pulumi.set(__self__, "script_parameters", script_parameters)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds and not isinstance(timeout_in_seconds, int):
            raise TypeError("Expected argument 'timeout_in_seconds' to be a int")
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if vantage_point_count and not isinstance(vantage_point_count, int):
            raise TypeError("Expected argument 'vantage_point_count' to be a int")
        pulumi.set(__self__, "vantage_point_count", vantage_point_count)
        if vantage_points and not isinstance(vantage_points, list):
            raise TypeError("Expected argument 'vantage_points' to be a list")
        pulumi.set(__self__, "vantage_points", vantage_points)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="availabilityConfigurations")
    def availability_configurations(self) -> Sequence['outputs.GetMonitorAvailabilityConfigurationResult']:
        """
        Monitor availability configuration details.
        """
        return pulumi.get(self, "availability_configurations")

    @property
    @pulumi.getter(name="batchIntervalInSeconds")
    def batch_interval_in_seconds(self) -> int:
        """
        Time interval between two runs in round robin batch mode (SchedulingPolicy - BATCHED_ROUND_ROBIN).
        """
        return pulumi.get(self, "batch_interval_in_seconds")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetMonitorConfigurationResult']:
        """
        Details of monitor configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isRunNow")
    def is_run_now(self) -> bool:
        """
        If isRunNow is enabled, then the monitor will run immediately.
        """
        return pulumi.get(self, "is_run_now")

    @property
    @pulumi.getter(name="isRunOnce")
    def is_run_once(self) -> bool:
        """
        If runOnce is enabled, then the monitor will run once.
        """
        return pulumi.get(self, "is_run_once")

    @property
    @pulumi.getter(name="maintenanceWindowSchedules")
    def maintenance_window_schedules(self) -> Sequence['outputs.GetMonitorMaintenanceWindowScheduleResult']:
        """
        Details required to schedule maintenance window.
        """
        return pulumi.get(self, "maintenance_window_schedules")

    @property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> str:
        return pulumi.get(self, "monitor_id")

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> str:
        """
        Type of monitor.
        """
        return pulumi.get(self, "monitor_type")

    @property
    @pulumi.getter(name="repeatIntervalInSeconds")
    def repeat_interval_in_seconds(self) -> int:
        """
        Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        """
        return pulumi.get(self, "repeat_interval_in_seconds")

    @property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> str:
        """
        Scheduling policy to decide the distribution of monitor executions on vantage points.
        """
        return pulumi.get(self, "scheduling_policy")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> str:
        """
        Name of the script.
        """
        return pulumi.get(self, "script_name")

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Sequence['outputs.GetMonitorScriptParameterResult']:
        """
        List of script parameters. Example: `[{"monitorScriptParameter": {"paramName": "userid", "paramValue":"testuser"}, "isSecret": false, "isOverwritten": false}]`
        """
        return pulumi.get(self, "script_parameters")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Enables or disables the monitor.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30% of repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50% of repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointCount")
    def vantage_point_count(self) -> int:
        """
        Number of vantage points where monitor is running.
        """
        return pulumi.get(self, "vantage_point_count")

    @property
    @pulumi.getter(name="vantagePoints")
    def vantage_points(self) -> Sequence['outputs.GetMonitorVantagePointResult']:
        """
        List of public and dedicated vantage points where the monitor is running.
        """
        return pulumi.get(self, "vantage_points")


class AwaitableGetMonitorResult(GetMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitorResult(
            apm_domain_id=self.apm_domain_id,
            availability_configurations=self.availability_configurations,
            batch_interval_in_seconds=self.batch_interval_in_seconds,
            configurations=self.configurations,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_run_now=self.is_run_now,
            is_run_once=self.is_run_once,
            maintenance_window_schedules=self.maintenance_window_schedules,
            monitor_id=self.monitor_id,
            monitor_type=self.monitor_type,
            repeat_interval_in_seconds=self.repeat_interval_in_seconds,
            scheduling_policy=self.scheduling_policy,
            script_id=self.script_id,
            script_name=self.script_name,
            script_parameters=self.script_parameters,
            status=self.status,
            target=self.target,
            time_created=self.time_created,
            time_updated=self.time_updated,
            timeout_in_seconds=self.timeout_in_seconds,
            vantage_point_count=self.vantage_point_count,
            vantage_points=self.vantage_points)


def get_monitor(apm_domain_id: Optional[str] = None,
                monitor_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitorResult:
    """
    This data source provides details about a specific Monitor resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the configuration of the monitor identified by the OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitor = oci.ApmSynthetics.get_monitor(apm_domain_id=test_apm_domain["id"],
        monitor_id=test_monitor_oci_apm_synthetics_monitor["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str monitor_id: The OCID of the monitor.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['monitorId'] = monitor_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getMonitor:getMonitor', __args__, opts=opts, typ=GetMonitorResult).value

    return AwaitableGetMonitorResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        availability_configurations=pulumi.get(__ret__, 'availability_configurations'),
        batch_interval_in_seconds=pulumi.get(__ret__, 'batch_interval_in_seconds'),
        configurations=pulumi.get(__ret__, 'configurations'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_run_now=pulumi.get(__ret__, 'is_run_now'),
        is_run_once=pulumi.get(__ret__, 'is_run_once'),
        maintenance_window_schedules=pulumi.get(__ret__, 'maintenance_window_schedules'),
        monitor_id=pulumi.get(__ret__, 'monitor_id'),
        monitor_type=pulumi.get(__ret__, 'monitor_type'),
        repeat_interval_in_seconds=pulumi.get(__ret__, 'repeat_interval_in_seconds'),
        scheduling_policy=pulumi.get(__ret__, 'scheduling_policy'),
        script_id=pulumi.get(__ret__, 'script_id'),
        script_name=pulumi.get(__ret__, 'script_name'),
        script_parameters=pulumi.get(__ret__, 'script_parameters'),
        status=pulumi.get(__ret__, 'status'),
        target=pulumi.get(__ret__, 'target'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        timeout_in_seconds=pulumi.get(__ret__, 'timeout_in_seconds'),
        vantage_point_count=pulumi.get(__ret__, 'vantage_point_count'),
        vantage_points=pulumi.get(__ret__, 'vantage_points'))


@_utilities.lift_output_func(get_monitor)
def get_monitor_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                       monitor_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitorResult]:
    """
    This data source provides details about a specific Monitor resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the configuration of the monitor identified by the OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitor = oci.ApmSynthetics.get_monitor(apm_domain_id=test_apm_domain["id"],
        monitor_id=test_monitor_oci_apm_synthetics_monitor["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str monitor_id: The OCID of the monitor.
    """
    ...
