# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetResultResult',
    'AwaitableGetResultResult',
    'get_result',
    'get_result_output',
]

@pulumi.output_type
class GetResultResult:
    """
    A collection of values returned by getResult.
    """
    def __init__(__self__, apm_domain_id=None, execution_time=None, id=None, monitor_id=None, result_content_type=None, result_data_sets=None, result_type=None, vantage_point=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if execution_time and not isinstance(execution_time, str):
            raise TypeError("Expected argument 'execution_time' to be a str")
        pulumi.set(__self__, "execution_time", execution_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitor_id and not isinstance(monitor_id, str):
            raise TypeError("Expected argument 'monitor_id' to be a str")
        pulumi.set(__self__, "monitor_id", monitor_id)
        if result_content_type and not isinstance(result_content_type, str):
            raise TypeError("Expected argument 'result_content_type' to be a str")
        pulumi.set(__self__, "result_content_type", result_content_type)
        if result_data_sets and not isinstance(result_data_sets, list):
            raise TypeError("Expected argument 'result_data_sets' to be a list")
        pulumi.set(__self__, "result_data_sets", result_data_sets)
        if result_type and not isinstance(result_type, str):
            raise TypeError("Expected argument 'result_type' to be a str")
        pulumi.set(__self__, "result_type", result_type)
        if vantage_point and not isinstance(vantage_point, str):
            raise TypeError("Expected argument 'vantage_point' to be a str")
        pulumi.set(__self__, "vantage_point", vantage_point)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> str:
        """
        The specific point of time when the result of an execution is collected.
        """
        return pulumi.get(self, "execution_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitor.
        """
        return pulumi.get(self, "monitor_id")

    @property
    @pulumi.getter(name="resultContentType")
    def result_content_type(self) -> str:
        """
        Type of result content. Example: Zip or Raw file.
        """
        return pulumi.get(self, "result_content_type")

    @property
    @pulumi.getter(name="resultDataSets")
    def result_data_sets(self) -> Sequence['outputs.GetResultResultDataSetResult']:
        """
        Monitor result data set.
        """
        return pulumi.get(self, "result_data_sets")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result. Example: HAR, Screenshot, Log or Network.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="vantagePoint")
    def vantage_point(self) -> str:
        """
        The name of the public or dedicated vantage point.
        """
        return pulumi.get(self, "vantage_point")


class AwaitableGetResultResult(GetResultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResultResult(
            apm_domain_id=self.apm_domain_id,
            execution_time=self.execution_time,
            id=self.id,
            monitor_id=self.monitor_id,
            result_content_type=self.result_content_type,
            result_data_sets=self.result_data_sets,
            result_type=self.result_type,
            vantage_point=self.vantage_point)


def get_result(apm_domain_id: Optional[str] = None,
               execution_time: Optional[str] = None,
               monitor_id: Optional[str] = None,
               result_content_type: Optional[str] = None,
               result_type: Optional[str] = None,
               vantage_point: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResultResult:
    """
    This data source provides details about a specific Result resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the results for a specific execution of a monitor identified by OCID. The results are in a HAR file, Screenshot, Console Log or Network details.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_result = oci.ApmSynthetics.get_result(apm_domain_id=test_apm_domain["id"],
        execution_time=result_execution_time,
        monitor_id=test_monitor["id"],
        result_content_type=result_result_content_type,
        result_type=result_result_type,
        vantage_point=result_vantage_point)
    ```
    <!--End PulumiCodeChooser -->


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str execution_time: The time the object was posted.
    :param str monitor_id: The OCID of the monitor.
    :param str result_content_type: The result content type: zip or raw.
    :param str result_type: The result type: har, screenshot, log, or network.
    :param str vantage_point: The vantagePoint name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['executionTime'] = execution_time
    __args__['monitorId'] = monitor_id
    __args__['resultContentType'] = result_content_type
    __args__['resultType'] = result_type
    __args__['vantagePoint'] = vantage_point
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getResult:getResult', __args__, opts=opts, typ=GetResultResult).value

    return AwaitableGetResultResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        execution_time=pulumi.get(__ret__, 'execution_time'),
        id=pulumi.get(__ret__, 'id'),
        monitor_id=pulumi.get(__ret__, 'monitor_id'),
        result_content_type=pulumi.get(__ret__, 'result_content_type'),
        result_data_sets=pulumi.get(__ret__, 'result_data_sets'),
        result_type=pulumi.get(__ret__, 'result_type'),
        vantage_point=pulumi.get(__ret__, 'vantage_point'))


@_utilities.lift_output_func(get_result)
def get_result_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                      execution_time: Optional[pulumi.Input[str]] = None,
                      monitor_id: Optional[pulumi.Input[str]] = None,
                      result_content_type: Optional[pulumi.Input[str]] = None,
                      result_type: Optional[pulumi.Input[str]] = None,
                      vantage_point: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResultResult]:
    """
    This data source provides details about a specific Result resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the results for a specific execution of a monitor identified by OCID. The results are in a HAR file, Screenshot, Console Log or Network details.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_result = oci.ApmSynthetics.get_result(apm_domain_id=test_apm_domain["id"],
        execution_time=result_execution_time,
        monitor_id=test_monitor["id"],
        result_content_type=result_result_content_type,
        result_type=result_result_type,
        vantage_point=result_vantage_point)
    ```
    <!--End PulumiCodeChooser -->


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str execution_time: The time the object was posted.
    :param str monitor_id: The OCID of the monitor.
    :param str result_content_type: The result content type: zip or raw.
    :param str result_type: The result type: har, screenshot, log, or network.
    :param str vantage_point: The vantagePoint name.
    """
    ...
