# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MonitorPluginManagementArgs', 'MonitorPluginManagement']

@pulumi.input_type
class MonitorPluginManagementArgs:
    def __init__(__self__, *,
                 monitored_instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a MonitorPluginManagement resource.
        :param pulumi.Input[str] monitored_instance_id: OCID of monitored instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "monitored_instance_id", monitored_instance_id)

    @property
    @pulumi.getter(name="monitoredInstanceId")
    def monitored_instance_id(self) -> pulumi.Input[str]:
        """
        OCID of monitored instance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "monitored_instance_id")

    @monitored_instance_id.setter
    def monitored_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitored_instance_id", value)


@pulumi.input_type
class _MonitorPluginManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 monitored_instance_description: Optional[pulumi.Input[str]] = None,
                 monitored_instance_display_name: Optional[pulumi.Input[str]] = None,
                 monitored_instance_id: Optional[pulumi.Input[str]] = None,
                 monitored_instance_management_agent_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MonitorPluginManagement resources.
        :param pulumi.Input[str] monitored_instance_id: OCID of monitored instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if monitored_instance_description is not None:
            pulumi.set(__self__, "monitored_instance_description", monitored_instance_description)
        if monitored_instance_display_name is not None:
            pulumi.set(__self__, "monitored_instance_display_name", monitored_instance_display_name)
        if monitored_instance_id is not None:
            pulumi.set(__self__, "monitored_instance_id", monitored_instance_id)
        if monitored_instance_management_agent_id is not None:
            pulumi.set(__self__, "monitored_instance_management_agent_id", monitored_instance_management_agent_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="monitoredInstanceDescription")
    def monitored_instance_description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "monitored_instance_description")

    @monitored_instance_description.setter
    def monitored_instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_instance_description", value)

    @property
    @pulumi.getter(name="monitoredInstanceDisplayName")
    def monitored_instance_display_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "monitored_instance_display_name")

    @monitored_instance_display_name.setter
    def monitored_instance_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_instance_display_name", value)

    @property
    @pulumi.getter(name="monitoredInstanceId")
    def monitored_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of monitored instance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "monitored_instance_id")

    @monitored_instance_id.setter
    def monitored_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_instance_id", value)

    @property
    @pulumi.getter(name="monitoredInstanceManagementAgentId")
    def monitored_instance_management_agent_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "monitored_instance_management_agent_id")

    @monitored_instance_management_agent_id.setter
    def monitored_instance_management_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_instance_management_agent_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class MonitorPluginManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 monitored_instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Monitor Plugin Management resource in Oracle Cloud Infrastructure Appmgmt Control service.

        Activates Resource Plugin for compute instance identified by the instance ocid.
        Stores monitored instances Id and its state. Tries to enable Resource Monitoring plugin by making
        remote calls to Oracle Cloud Agent and Management Agent Cloud Service.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitor_plugin_management = oci.app_mgmt_control.MonitorPluginManagement("test_monitor_plugin_management", monitored_instance_id=test_monitored_instance["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] monitored_instance_id: OCID of monitored instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorPluginManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitor Plugin Management resource in Oracle Cloud Infrastructure Appmgmt Control service.

        Activates Resource Plugin for compute instance identified by the instance ocid.
        Stores monitored instances Id and its state. Tries to enable Resource Monitoring plugin by making
        remote calls to Oracle Cloud Agent and Management Agent Cloud Service.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitor_plugin_management = oci.app_mgmt_control.MonitorPluginManagement("test_monitor_plugin_management", monitored_instance_id=test_monitored_instance["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param MonitorPluginManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorPluginManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 monitored_instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorPluginManagementArgs.__new__(MonitorPluginManagementArgs)

            if monitored_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'monitored_instance_id'")
            __props__.__dict__["monitored_instance_id"] = monitored_instance_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["monitored_instance_description"] = None
            __props__.__dict__["monitored_instance_display_name"] = None
            __props__.__dict__["monitored_instance_management_agent_id"] = None
            __props__.__dict__["state"] = None
        super(MonitorPluginManagement, __self__).__init__(
            'oci:AppMgmtControl/monitorPluginManagement:MonitorPluginManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            monitored_instance_description: Optional[pulumi.Input[str]] = None,
            monitored_instance_display_name: Optional[pulumi.Input[str]] = None,
            monitored_instance_id: Optional[pulumi.Input[str]] = None,
            monitored_instance_management_agent_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'MonitorPluginManagement':
        """
        Get an existing MonitorPluginManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] monitored_instance_id: OCID of monitored instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorPluginManagementState.__new__(_MonitorPluginManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["monitored_instance_description"] = monitored_instance_description
        __props__.__dict__["monitored_instance_display_name"] = monitored_instance_display_name
        __props__.__dict__["monitored_instance_id"] = monitored_instance_id
        __props__.__dict__["monitored_instance_management_agent_id"] = monitored_instance_management_agent_id
        __props__.__dict__["state"] = state
        return MonitorPluginManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="monitoredInstanceDescription")
    def monitored_instance_description(self) -> pulumi.Output[str]:
        return pulumi.get(self, "monitored_instance_description")

    @property
    @pulumi.getter(name="monitoredInstanceDisplayName")
    def monitored_instance_display_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "monitored_instance_display_name")

    @property
    @pulumi.getter(name="monitoredInstanceId")
    def monitored_instance_id(self) -> pulumi.Output[str]:
        """
        OCID of monitored instance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "monitored_instance_id")

    @property
    @pulumi.getter(name="monitoredInstanceManagementAgentId")
    def monitored_instance_management_agent_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "monitored_instance_management_agent_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

