# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BudgetArgs', 'Budget']

@pulumi.input_type
class BudgetArgs:
    def __init__(__self__, *,
                 amount: pulumi.Input[int],
                 compartment_id: pulumi.Input[str],
                 reset_period: pulumi.Input[str],
                 budget_processing_period_start_offset: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 processing_period_type: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Budget resource.
        :param pulumi.Input[int] amount: (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] reset_period: (Updatable) The reset period for the budget. Valid value is MONTHLY.
        :param pulumi.Input[int] budget_processing_period_start_offset: (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the budget.
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the budget. Avoid entering confidential information.
        :param pulumi.Input[str] end_date: (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] processing_period_type: (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param pulumi.Input[str] start_date: (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[str] target_compartment_id: This is DEPRECATED. Set the target compartment ID in targets instead.
        :param pulumi.Input[str] target_type: The type of target on which the budget is applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "reset_period", reset_period)
        if budget_processing_period_start_offset is not None:
            pulumi.set(__self__, "budget_processing_period_start_offset", budget_processing_period_start_offset)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if processing_period_type is not None:
            pulumi.set(__self__, "processing_period_type", processing_period_type)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if target_compartment_id is not None:
            warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
            pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")
        if target_compartment_id is not None:
            pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def amount(self) -> pulumi.Input[int]:
        """
        (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: pulumi.Input[int]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> pulumi.Input[str]:
        """
        (Updatable) The reset period for the budget. Valid value is MONTHLY.
        """
        return pulumi.get(self, "reset_period")

    @reset_period.setter
    def reset_period(self, value: pulumi.Input[str]):
        pulumi.set(self, "reset_period", value)

    @property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @budget_processing_period_start_offset.setter
    def budget_processing_period_start_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "budget_processing_period_start_offset", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the budget.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The displayName of the budget. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @processing_period_type.setter
    def processing_period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "processing_period_type", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is DEPRECATED. Set the target compartment ID in targets instead.
        """
        warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
        pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")

        return pulumi.get(self, "target_compartment_id")

    @target_compartment_id.setter
    def target_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_compartment_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of target on which the budget is applied.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "targets", value)


@pulumi.input_type
class _BudgetState:
    def __init__(__self__, *,
                 actual_spend: Optional[pulumi.Input[float]] = None,
                 alert_rule_count: Optional[pulumi.Input[int]] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 budget_processing_period_start_offset: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 forecasted_spend: Optional[pulumi.Input[float]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 processing_period_type: Optional[pulumi.Input[str]] = None,
                 reset_period: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_spend_computed: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Budget resources.
        :param pulumi.Input[float] actual_spend: The actual spend in currency for the current budget cycle.
        :param pulumi.Input[int] alert_rule_count: The total number of alert rules in the budget.
        :param pulumi.Input[int] amount: (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        :param pulumi.Input[int] budget_processing_period_start_offset: (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the budget.
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the budget. Avoid entering confidential information.
        :param pulumi.Input[str] end_date: (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[float] forecasted_spend: The forecasted spend in currency by the end of the current budget cycle.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] processing_period_type: (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param pulumi.Input[str] reset_period: (Updatable) The reset period for the budget. Valid value is MONTHLY.
        :param pulumi.Input[str] start_date: (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[str] state: The current state of the budget.
        :param pulumi.Input[str] target_compartment_id: This is DEPRECATED. Set the target compartment ID in targets instead.
        :param pulumi.Input[str] target_type: The type of target on which the budget is applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time that the budget was created.
        :param pulumi.Input[str] time_spend_computed: The time that the budget spend was last computed.
        :param pulumi.Input[str] time_updated: The time that the budget was updated.
        :param pulumi.Input[int] version: The version of the budget. Starts from 1 and increments by 1.
        """
        if actual_spend is not None:
            pulumi.set(__self__, "actual_spend", actual_spend)
        if alert_rule_count is not None:
            pulumi.set(__self__, "alert_rule_count", alert_rule_count)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if budget_processing_period_start_offset is not None:
            pulumi.set(__self__, "budget_processing_period_start_offset", budget_processing_period_start_offset)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if forecasted_spend is not None:
            pulumi.set(__self__, "forecasted_spend", forecasted_spend)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if processing_period_type is not None:
            pulumi.set(__self__, "processing_period_type", processing_period_type)
        if reset_period is not None:
            pulumi.set(__self__, "reset_period", reset_period)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_compartment_id is not None:
            warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
            pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")
        if target_compartment_id is not None:
            pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_spend_computed is not None:
            pulumi.set(__self__, "time_spend_computed", time_spend_computed)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="actualSpend")
    def actual_spend(self) -> Optional[pulumi.Input[float]]:
        """
        The actual spend in currency for the current budget cycle.
        """
        return pulumi.get(self, "actual_spend")

    @actual_spend.setter
    def actual_spend(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "actual_spend", value)

    @property
    @pulumi.getter(name="alertRuleCount")
    def alert_rule_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of alert rules in the budget.
        """
        return pulumi.get(self, "alert_rule_count")

    @alert_rule_count.setter
    def alert_rule_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alert_rule_count", value)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @budget_processing_period_start_offset.setter
    def budget_processing_period_start_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "budget_processing_period_start_offset", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the budget.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The displayName of the budget. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="forecastedSpend")
    def forecasted_spend(self) -> Optional[pulumi.Input[float]]:
        """
        The forecasted spend in currency by the end of the current budget cycle.
        """
        return pulumi.get(self, "forecasted_spend")

    @forecasted_spend.setter
    def forecasted_spend(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "forecasted_spend", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @processing_period_type.setter
    def processing_period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "processing_period_type", value)

    @property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The reset period for the budget. Valid value is MONTHLY.
        """
        return pulumi.get(self, "reset_period")

    @reset_period.setter
    def reset_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reset_period", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the budget.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is DEPRECATED. Set the target compartment ID in targets instead.
        """
        warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
        pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")

        return pulumi.get(self, "target_compartment_id")

    @target_compartment_id.setter
    def target_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_compartment_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of target on which the budget is applied.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the budget was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeSpendComputed")
    def time_spend_computed(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the budget spend was last computed.
        """
        return pulumi.get(self, "time_spend_computed")

    @time_spend_computed.setter
    def time_spend_computed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_spend_computed", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the budget. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class Budget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 budget_processing_period_start_offset: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 processing_period_type: Optional[pulumi.Input[str]] = None,
                 reset_period: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Budget resource in Oracle Cloud Infrastructure Budget service.

        Creates a new budget.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_budget = oci.budget.Budget("test_budget",
            amount=budget_amount,
            compartment_id=tenancy_ocid,
            reset_period=budget_reset_period,
            budget_processing_period_start_offset=budget_budget_processing_period_start_offset,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=budget_description,
            display_name=budget_display_name,
            end_date=budget_end_date,
            freeform_tags={
                "Department": "Finance",
            },
            processing_period_type=budget_processing_period_type,
            start_date=budget_start_date,
            target_compartment_id=test_compartment["id"],
            target_type=budget_target_type,
            targets=budget_targets)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Budgets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Budget/budget:Budget test_budget "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        :param pulumi.Input[int] budget_processing_period_start_offset: (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the budget.
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the budget. Avoid entering confidential information.
        :param pulumi.Input[str] end_date: (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] processing_period_type: (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param pulumi.Input[str] reset_period: (Updatable) The reset period for the budget. Valid value is MONTHLY.
        :param pulumi.Input[str] start_date: (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[str] target_compartment_id: This is DEPRECATED. Set the target compartment ID in targets instead.
        :param pulumi.Input[str] target_type: The type of target on which the budget is applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BudgetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Budget resource in Oracle Cloud Infrastructure Budget service.

        Creates a new budget.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_budget = oci.budget.Budget("test_budget",
            amount=budget_amount,
            compartment_id=tenancy_ocid,
            reset_period=budget_reset_period,
            budget_processing_period_start_offset=budget_budget_processing_period_start_offset,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=budget_description,
            display_name=budget_display_name,
            end_date=budget_end_date,
            freeform_tags={
                "Department": "Finance",
            },
            processing_period_type=budget_processing_period_type,
            start_date=budget_start_date,
            target_compartment_id=test_compartment["id"],
            target_type=budget_target_type,
            targets=budget_targets)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Budgets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Budget/budget:Budget test_budget "id"
        ```

        :param str resource_name: The name of the resource.
        :param BudgetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BudgetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 budget_processing_period_start_offset: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 processing_period_type: Optional[pulumi.Input[str]] = None,
                 reset_period: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BudgetArgs.__new__(BudgetArgs)

            if amount is None and not opts.urn:
                raise TypeError("Missing required property 'amount'")
            __props__.__dict__["amount"] = amount
            __props__.__dict__["budget_processing_period_start_offset"] = budget_processing_period_start_offset
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["end_date"] = end_date
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["processing_period_type"] = processing_period_type
            if reset_period is None and not opts.urn:
                raise TypeError("Missing required property 'reset_period'")
            __props__.__dict__["reset_period"] = reset_period
            __props__.__dict__["start_date"] = start_date
            __props__.__dict__["target_compartment_id"] = target_compartment_id
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["targets"] = targets
            __props__.__dict__["actual_spend"] = None
            __props__.__dict__["alert_rule_count"] = None
            __props__.__dict__["forecasted_spend"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_spend_computed"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(Budget, __self__).__init__(
            'oci:Budget/budget:Budget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actual_spend: Optional[pulumi.Input[float]] = None,
            alert_rule_count: Optional[pulumi.Input[int]] = None,
            amount: Optional[pulumi.Input[int]] = None,
            budget_processing_period_start_offset: Optional[pulumi.Input[int]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            end_date: Optional[pulumi.Input[str]] = None,
            forecasted_spend: Optional[pulumi.Input[float]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            processing_period_type: Optional[pulumi.Input[str]] = None,
            reset_period: Optional[pulumi.Input[str]] = None,
            start_date: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            target_compartment_id: Optional[pulumi.Input[str]] = None,
            target_type: Optional[pulumi.Input[str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_spend_computed: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'Budget':
        """
        Get an existing Budget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] actual_spend: The actual spend in currency for the current budget cycle.
        :param pulumi.Input[int] alert_rule_count: The total number of alert rules in the budget.
        :param pulumi.Input[int] amount: (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        :param pulumi.Input[int] budget_processing_period_start_offset: (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the budget.
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the budget. Avoid entering confidential information.
        :param pulumi.Input[str] end_date: (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[float] forecasted_spend: The forecasted spend in currency by the end of the current budget cycle.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] processing_period_type: (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param pulumi.Input[str] reset_period: (Updatable) The reset period for the budget. Valid value is MONTHLY.
        :param pulumi.Input[str] start_date: (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param pulumi.Input[str] state: The current state of the budget.
        :param pulumi.Input[str] target_compartment_id: This is DEPRECATED. Set the target compartment ID in targets instead.
        :param pulumi.Input[str] target_type: The type of target on which the budget is applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time that the budget was created.
        :param pulumi.Input[str] time_spend_computed: The time that the budget spend was last computed.
        :param pulumi.Input[str] time_updated: The time that the budget was updated.
        :param pulumi.Input[int] version: The version of the budget. Starts from 1 and increments by 1.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BudgetState.__new__(_BudgetState)

        __props__.__dict__["actual_spend"] = actual_spend
        __props__.__dict__["alert_rule_count"] = alert_rule_count
        __props__.__dict__["amount"] = amount
        __props__.__dict__["budget_processing_period_start_offset"] = budget_processing_period_start_offset
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["end_date"] = end_date
        __props__.__dict__["forecasted_spend"] = forecasted_spend
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["processing_period_type"] = processing_period_type
        __props__.__dict__["reset_period"] = reset_period
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["state"] = state
        __props__.__dict__["target_compartment_id"] = target_compartment_id
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["targets"] = targets
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_spend_computed"] = time_spend_computed
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return Budget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actualSpend")
    def actual_spend(self) -> pulumi.Output[float]:
        """
        The actual spend in currency for the current budget cycle.
        """
        return pulumi.get(self, "actual_spend")

    @property
    @pulumi.getter(name="alertRuleCount")
    def alert_rule_count(self) -> pulumi.Output[int]:
        """
        The total number of alert rules in the budget.
        """
        return pulumi.get(self, "alert_rule_count")

    @property
    @pulumi.getter
    def amount(self) -> pulumi.Output[int]:
        """
        (Updatable) The amount of the budget expressed as a whole number in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the budget.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The displayName of the budget. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Output[str]:
        """
        (Updatable) The date when the one-time budget concludes. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="forecastedSpend")
    def forecasted_spend(self) -> pulumi.Output[float]:
        """
        The forecasted spend in currency by the end of the current budget cycle.
        """
        return pulumi.get(self, "forecasted_spend")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> pulumi.Output[str]:
        """
        (Updatable) The reset period for the budget. Valid value is MONTHLY.
        """
        return pulumi.get(self, "reset_period")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[str]:
        """
        (Updatable) The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the budget.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> pulumi.Output[str]:
        """
        This is DEPRECATED. Set the target compartment ID in targets instead.
        """
        warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
        pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")

        return pulumi.get(self, "target_compartment_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        The type of target on which the budget is applied.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of targets on which the budget is applied. If targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}". Curerntly, the array should contain exactly one item. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time that the budget was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSpendComputed")
    def time_spend_computed(self) -> pulumi.Output[str]:
        """
        The time that the budget spend was last computed.
        """
        return pulumi.get(self, "time_spend_computed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time that the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the budget. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")

