# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOccAvailabilityCatalogOccAvailabilitiesResult',
    'AwaitableGetOccAvailabilityCatalogOccAvailabilitiesResult',
    'get_occ_availability_catalog_occ_availabilities',
    'get_occ_availability_catalog_occ_availabilities_output',
]

@pulumi.output_type
class GetOccAvailabilityCatalogOccAvailabilitiesResult:
    """
    A collection of values returned by getOccAvailabilityCatalogOccAvailabilities.
    """
    def __init__(__self__, date_expected_capacity_handover=None, filters=None, id=None, occ_availability_catalog_id=None, occ_availability_collections=None, resource_name=None, resource_type=None, workload_type=None):
        if date_expected_capacity_handover and not isinstance(date_expected_capacity_handover, str):
            raise TypeError("Expected argument 'date_expected_capacity_handover' to be a str")
        pulumi.set(__self__, "date_expected_capacity_handover", date_expected_capacity_handover)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if occ_availability_catalog_id and not isinstance(occ_availability_catalog_id, str):
            raise TypeError("Expected argument 'occ_availability_catalog_id' to be a str")
        pulumi.set(__self__, "occ_availability_catalog_id", occ_availability_catalog_id)
        if occ_availability_collections and not isinstance(occ_availability_collections, list):
            raise TypeError("Expected argument 'occ_availability_collections' to be a list")
        pulumi.set(__self__, "occ_availability_collections", occ_availability_collections)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if workload_type and not isinstance(workload_type, str):
            raise TypeError("Expected argument 'workload_type' to be a str")
        pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> Optional[str]:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOccAvailabilityCatalogOccAvailabilitiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="occAvailabilityCatalogId")
    def occ_availability_catalog_id(self) -> str:
        return pulumi.get(self, "occ_availability_catalog_id")

    @property
    @pulumi.getter(name="occAvailabilityCollections")
    def occ_availability_collections(self) -> Sequence['outputs.GetOccAvailabilityCatalogOccAvailabilitiesOccAvailabilityCollectionResult']:
        """
        The list of occ_availability_collection.
        """
        return pulumi.get(self, "occ_availability_collections")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[str]:
        """
        The name of the resource that the customer can request.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        The different types of resources against which customers can place capacity requests.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        The type of workload (Generic/ROW).
        """
        return pulumi.get(self, "workload_type")


class AwaitableGetOccAvailabilityCatalogOccAvailabilitiesResult(GetOccAvailabilityCatalogOccAvailabilitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccAvailabilityCatalogOccAvailabilitiesResult(
            date_expected_capacity_handover=self.date_expected_capacity_handover,
            filters=self.filters,
            id=self.id,
            occ_availability_catalog_id=self.occ_availability_catalog_id,
            occ_availability_collections=self.occ_availability_collections,
            resource_name=self.resource_name,
            resource_type=self.resource_type,
            workload_type=self.workload_type)


def get_occ_availability_catalog_occ_availabilities(date_expected_capacity_handover: Optional[str] = None,
                                                    filters: Optional[Sequence[pulumi.InputType['GetOccAvailabilityCatalogOccAvailabilitiesFilterArgs']]] = None,
                                                    occ_availability_catalog_id: Optional[str] = None,
                                                    resource_name: Optional[str] = None,
                                                    resource_type: Optional[str] = None,
                                                    workload_type: Optional[str] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccAvailabilityCatalogOccAvailabilitiesResult:
    """
    This data source provides the list of Occ Availability Catalog Occ Availabilities in Oracle Cloud Infrastructure Capacity Management service.

    Lists availabilities for a particular availability catalog.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_availability_catalog_occ_availabilities = oci.CapacityManagement.get_occ_availability_catalog_occ_availabilities(occ_availability_catalog_id=test_occ_availability_catalog["id"],
        date_expected_capacity_handover=occ_availability_catalog_occ_availability_date_expected_capacity_handover,
        resource_name=test_resource["name"],
        resource_type=occ_availability_catalog_occ_availability_resource_type,
        workload_type=occ_availability_catalog_occ_availability_workload_type)
    ```
    <!--End PulumiCodeChooser -->


    :param str date_expected_capacity_handover: The capacity handover date of the capacity constraint to filter the list of capacity constraints.
    :param str occ_availability_catalog_id: The OCID of the availability catalog.
    :param str resource_name: The name of the resource to filter the list of capacity constraints.
    :param str resource_type: Resource type using which the capacity constraints of an availability catalog can be filtered.
    :param str workload_type: Workload type using the resources in an availability catalog can be filtered.
    """
    __args__ = dict()
    __args__['dateExpectedCapacityHandover'] = date_expected_capacity_handover
    __args__['filters'] = filters
    __args__['occAvailabilityCatalogId'] = occ_availability_catalog_id
    __args__['resourceName'] = resource_name
    __args__['resourceType'] = resource_type
    __args__['workloadType'] = workload_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccAvailabilityCatalogOccAvailabilities:getOccAvailabilityCatalogOccAvailabilities', __args__, opts=opts, typ=GetOccAvailabilityCatalogOccAvailabilitiesResult).value

    return AwaitableGetOccAvailabilityCatalogOccAvailabilitiesResult(
        date_expected_capacity_handover=pulumi.get(__ret__, 'date_expected_capacity_handover'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        occ_availability_catalog_id=pulumi.get(__ret__, 'occ_availability_catalog_id'),
        occ_availability_collections=pulumi.get(__ret__, 'occ_availability_collections'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        workload_type=pulumi.get(__ret__, 'workload_type'))


@_utilities.lift_output_func(get_occ_availability_catalog_occ_availabilities)
def get_occ_availability_catalog_occ_availabilities_output(date_expected_capacity_handover: Optional[pulumi.Input[Optional[str]]] = None,
                                                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOccAvailabilityCatalogOccAvailabilitiesFilterArgs']]]]] = None,
                                                           occ_availability_catalog_id: Optional[pulumi.Input[str]] = None,
                                                           resource_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                           resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                                                           workload_type: Optional[pulumi.Input[Optional[str]]] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOccAvailabilityCatalogOccAvailabilitiesResult]:
    """
    This data source provides the list of Occ Availability Catalog Occ Availabilities in Oracle Cloud Infrastructure Capacity Management service.

    Lists availabilities for a particular availability catalog.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_availability_catalog_occ_availabilities = oci.CapacityManagement.get_occ_availability_catalog_occ_availabilities(occ_availability_catalog_id=test_occ_availability_catalog["id"],
        date_expected_capacity_handover=occ_availability_catalog_occ_availability_date_expected_capacity_handover,
        resource_name=test_resource["name"],
        resource_type=occ_availability_catalog_occ_availability_resource_type,
        workload_type=occ_availability_catalog_occ_availability_workload_type)
    ```
    <!--End PulumiCodeChooser -->


    :param str date_expected_capacity_handover: The capacity handover date of the capacity constraint to filter the list of capacity constraints.
    :param str occ_availability_catalog_id: The OCID of the availability catalog.
    :param str resource_name: The name of the resource to filter the list of capacity constraints.
    :param str resource_type: Resource type using which the capacity constraints of an availability catalog can be filtered.
    :param str workload_type: Workload type using the resources in an availability catalog can be filtered.
    """
    ...
