# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCaBundlesResult',
    'AwaitableGetCaBundlesResult',
    'get_ca_bundles',
    'get_ca_bundles_output',
]

@pulumi.output_type
class GetCaBundlesResult:
    """
    A collection of values returned by getCaBundles.
    """
    def __init__(__self__, ca_bundle_collections=None, ca_bundle_id=None, compartment_id=None, filters=None, id=None, name=None, state=None):
        if ca_bundle_collections and not isinstance(ca_bundle_collections, list):
            raise TypeError("Expected argument 'ca_bundle_collections' to be a list")
        pulumi.set(__self__, "ca_bundle_collections", ca_bundle_collections)
        if ca_bundle_id and not isinstance(ca_bundle_id, str):
            raise TypeError("Expected argument 'ca_bundle_id' to be a str")
        pulumi.set(__self__, "ca_bundle_id", ca_bundle_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="caBundleCollections")
    def ca_bundle_collections(self) -> Sequence['outputs.GetCaBundlesCaBundleCollectionResult']:
        """
        The list of ca_bundle_collection.
        """
        return pulumi.get(self, "ca_bundle_collections")

    @property
    @pulumi.getter(name="caBundleId")
    def ca_bundle_id(self) -> Optional[str]:
        return pulumi.get(self, "ca_bundle_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment for the CA bundle.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCaBundlesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A user-friendly name for the CA bundle. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the CA bundle.
        """
        return pulumi.get(self, "state")


class AwaitableGetCaBundlesResult(GetCaBundlesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCaBundlesResult(
            ca_bundle_collections=self.ca_bundle_collections,
            ca_bundle_id=self.ca_bundle_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_ca_bundles(ca_bundle_id: Optional[str] = None,
                   compartment_id: Optional[str] = None,
                   filters: Optional[Sequence[pulumi.InputType['GetCaBundlesFilterArgs']]] = None,
                   name: Optional[str] = None,
                   state: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCaBundlesResult:
    """
    This data source provides the list of Ca Bundles in Oracle Cloud Infrastructure Certificates Management service.

    Lists all CA bundles that match the query parameters.
    Optionally, you can use the parameter `FilterByCaBundleIdQueryParam` to limit the result set to a single item that matches the specified CA bundle.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_ca_bundles = oci.CertificatesManagement.get_ca_bundles(ca_bundle_id=test_ca_bundle["id"],
        compartment_id=compartment_id,
        name=ca_bundle_name,
        state=ca_bundle_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str ca_bundle_id: The OCID of the CA bundle.
    :param str compartment_id: A filter that returns only resources that match the given compartment OCID.
    :param str name: A filter that returns only resources that match the specified name.
    :param str state: A filter that returns only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['caBundleId'] = ca_bundle_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getCaBundles:getCaBundles', __args__, opts=opts, typ=GetCaBundlesResult).value

    return AwaitableGetCaBundlesResult(
        ca_bundle_collections=pulumi.get(__ret__, 'ca_bundle_collections'),
        ca_bundle_id=pulumi.get(__ret__, 'ca_bundle_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_ca_bundles)
def get_ca_bundles_output(ca_bundle_id: Optional[pulumi.Input[Optional[str]]] = None,
                          compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetCaBundlesFilterArgs']]]]] = None,
                          name: Optional[pulumi.Input[Optional[str]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCaBundlesResult]:
    """
    This data source provides the list of Ca Bundles in Oracle Cloud Infrastructure Certificates Management service.

    Lists all CA bundles that match the query parameters.
    Optionally, you can use the parameter `FilterByCaBundleIdQueryParam` to limit the result set to a single item that matches the specified CA bundle.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_ca_bundles = oci.CertificatesManagement.get_ca_bundles(ca_bundle_id=test_ca_bundle["id"],
        compartment_id=compartment_id,
        name=ca_bundle_name,
        state=ca_bundle_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str ca_bundle_id: The OCID of the CA bundle.
    :param str compartment_id: A filter that returns only resources that match the given compartment OCID.
    :param str name: A filter that returns only resources that match the specified name.
    :param str state: A filter that returns only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    ...
