# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDetectorRecipeResult',
    'AwaitableGetDetectorRecipeResult',
    'get_detector_recipe',
    'get_detector_recipe_output',
]

@pulumi.output_type
class GetDetectorRecipeResult:
    """
    A collection of values returned by getDetectorRecipe.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, detector=None, detector_recipe_id=None, detector_rules=None, display_name=None, effective_detector_rules=None, freeform_tags=None, id=None, owner=None, source_detector_recipe_id=None, state=None, system_tags=None, target_ids=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if detector and not isinstance(detector, str):
            raise TypeError("Expected argument 'detector' to be a str")
        pulumi.set(__self__, "detector", detector)
        if detector_recipe_id and not isinstance(detector_recipe_id, str):
            raise TypeError("Expected argument 'detector_recipe_id' to be a str")
        pulumi.set(__self__, "detector_recipe_id", detector_recipe_id)
        if detector_rules and not isinstance(detector_rules, list):
            raise TypeError("Expected argument 'detector_rules' to be a list")
        pulumi.set(__self__, "detector_rules", detector_rules)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_detector_rules and not isinstance(effective_detector_rules, list):
            raise TypeError("Expected argument 'effective_detector_rules' to be a list")
        pulumi.set(__self__, "effective_detector_rules", effective_detector_rules)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if source_detector_recipe_id and not isinstance(source_detector_recipe_id, str):
            raise TypeError("Expected argument 'source_detector_recipe_id' to be a str")
        pulumi.set(__self__, "source_detector_recipe_id", source_detector_recipe_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_ids and not isinstance(target_ids, list):
            raise TypeError("Expected argument 'target_ids' to be a list")
        pulumi.set(__self__, "target_ids", target_ids)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        compartmentId of detector recipe
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for DetectorRecipeDetectorRule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def detector(self) -> str:
        """
        detector for the rule
        """
        return pulumi.get(self, "detector")

    @property
    @pulumi.getter(name="detectorRecipeId")
    def detector_recipe_id(self) -> str:
        return pulumi.get(self, "detector_recipe_id")

    @property
    @pulumi.getter(name="detectorRules")
    def detector_rules(self) -> Sequence['outputs.GetDetectorRecipeDetectorRuleResult']:
        """
        List of detector rules for the detector type for recipe - user input
        """
        return pulumi.get(self, "detector_rules")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of entity
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveDetectorRules")
    def effective_detector_rules(self) -> Sequence['outputs.GetDetectorRecipeEffectiveDetectorRuleResult']:
        """
        List of effective detector rules for the detector type for recipe after applying defaults
        """
        return pulumi.get(self, "effective_detector_rules")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Ocid for detector recipe
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of detector recipe
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="sourceDetectorRecipeId")
    def source_detector_recipe_id(self) -> str:
        """
        Recipe Ocid of the Source Recipe to be cloned
        """
        return pulumi.get(self, "source_detector_recipe_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Sequence[str]:
        """
        The recipe attached to targets
        """
        return pulumi.get(self, "target_ids")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the detector recipe was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the detector recipe was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDetectorRecipeResult(GetDetectorRecipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDetectorRecipeResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            detector=self.detector,
            detector_recipe_id=self.detector_recipe_id,
            detector_rules=self.detector_rules,
            display_name=self.display_name,
            effective_detector_rules=self.effective_detector_rules,
            freeform_tags=self.freeform_tags,
            id=self.id,
            owner=self.owner,
            source_detector_recipe_id=self.source_detector_recipe_id,
            state=self.state,
            system_tags=self.system_tags,
            target_ids=self.target_ids,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_detector_recipe(detector_recipe_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDetectorRecipeResult:
    """
    This data source provides details about a specific Detector Recipe resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a detector recipe (DetectorRecipe object) identified by detectorRecipeId.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_detector_recipe = oci.CloudGuard.get_detector_recipe(detector_recipe_id=test_detector_recipe_oci_cloud_guard_detector_recipe["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str detector_recipe_id: DetectorRecipe OCID
    """
    __args__ = dict()
    __args__['detectorRecipeId'] = detector_recipe_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDetectorRecipe:getDetectorRecipe', __args__, opts=opts, typ=GetDetectorRecipeResult).value

    return AwaitableGetDetectorRecipeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        detector=pulumi.get(__ret__, 'detector'),
        detector_recipe_id=pulumi.get(__ret__, 'detector_recipe_id'),
        detector_rules=pulumi.get(__ret__, 'detector_rules'),
        display_name=pulumi.get(__ret__, 'display_name'),
        effective_detector_rules=pulumi.get(__ret__, 'effective_detector_rules'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        owner=pulumi.get(__ret__, 'owner'),
        source_detector_recipe_id=pulumi.get(__ret__, 'source_detector_recipe_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_ids=pulumi.get(__ret__, 'target_ids'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_detector_recipe)
def get_detector_recipe_output(detector_recipe_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDetectorRecipeResult]:
    """
    This data source provides details about a specific Detector Recipe resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a detector recipe (DetectorRecipe object) identified by detectorRecipeId.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_detector_recipe = oci.CloudGuard.get_detector_recipe(detector_recipe_id=test_detector_recipe_oci_cloud_guard_detector_recipe["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str detector_recipe_id: DetectorRecipe OCID
    """
    ...
