# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDetectorRecipesResult',
    'AwaitableGetDetectorRecipesResult',
    'get_detector_recipes',
    'get_detector_recipes_output',
]

@pulumi.output_type
class GetDetectorRecipesResult:
    """
    A collection of values returned by getDetectorRecipes.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, detector_recipe_collections=None, display_name=None, filters=None, id=None, resource_metadata_only=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if detector_recipe_collections and not isinstance(detector_recipe_collections, list):
            raise TypeError("Expected argument 'detector_recipe_collections' to be a list")
        pulumi.set(__self__, "detector_recipe_collections", detector_recipe_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_metadata_only and not isinstance(resource_metadata_only, bool):
            raise TypeError("Expected argument 'resource_metadata_only' to be a bool")
        pulumi.set(__self__, "resource_metadata_only", resource_metadata_only)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        compartmentId of detector recipe
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="detectorRecipeCollections")
    def detector_recipe_collections(self) -> Sequence['outputs.GetDetectorRecipesDetectorRecipeCollectionResult']:
        """
        The list of detector_recipe_collection.
        """
        return pulumi.get(self, "detector_recipe_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of entity
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDetectorRecipesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceMetadataOnly")
    def resource_metadata_only(self) -> Optional[bool]:
        return pulumi.get(self, "resource_metadata_only")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDetectorRecipesResult(GetDetectorRecipesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDetectorRecipesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            detector_recipe_collections=self.detector_recipe_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_metadata_only=self.resource_metadata_only,
            state=self.state)


def get_detector_recipes(access_level: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         compartment_id_in_subtree: Optional[bool] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetDetectorRecipesFilterArgs']]] = None,
                         resource_metadata_only: Optional[bool] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDetectorRecipesResult:
    """
    This data source provides the list of Detector Recipes in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all detector recipes (DetectorRecipe objects) in a compartment, identified by compartmentId.

    The ListDetectorRecipes operation returns only the detector recipes in `compartmentId` passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListDetectorRecipes on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_detector_recipes = oci.CloudGuard.get_detector_recipes(compartment_id=compartment_id,
        access_level=detector_recipe_access_level,
        compartment_id_in_subtree=detector_recipe_compartment_id_in_subtree,
        display_name=detector_recipe_display_name,
        resource_metadata_only=detector_recipe_resource_metadata_only,
        state=detector_recipe_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param bool resource_metadata_only: Default is false. When set to true, the list of all Oracle Managed Resources Metadata supported by Cloud Guard are returned.
    :param str state: The field life cycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceMetadataOnly'] = resource_metadata_only
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDetectorRecipes:getDetectorRecipes', __args__, opts=opts, typ=GetDetectorRecipesResult).value

    return AwaitableGetDetectorRecipesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        detector_recipe_collections=pulumi.get(__ret__, 'detector_recipe_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_metadata_only=pulumi.get(__ret__, 'resource_metadata_only'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_detector_recipes)
def get_detector_recipes_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDetectorRecipesFilterArgs']]]]] = None,
                                resource_metadata_only: Optional[pulumi.Input[Optional[bool]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDetectorRecipesResult]:
    """
    This data source provides the list of Detector Recipes in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all detector recipes (DetectorRecipe objects) in a compartment, identified by compartmentId.

    The ListDetectorRecipes operation returns only the detector recipes in `compartmentId` passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListDetectorRecipes on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_detector_recipes = oci.CloudGuard.get_detector_recipes(compartment_id=compartment_id,
        access_level=detector_recipe_access_level,
        compartment_id_in_subtree=detector_recipe_compartment_id_in_subtree,
        display_name=detector_recipe_display_name,
        resource_metadata_only=detector_recipe_resource_metadata_only,
        state=detector_recipe_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param bool resource_metadata_only: Default is false. When set to true, the list of all Oracle Managed Resources Metadata supported by Cloud Guard are returned.
    :param str state: The field life cycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    ...
