# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReplicationSchedulesResult',
    'AwaitableGetReplicationSchedulesResult',
    'get_replication_schedules',
    'get_replication_schedules_output',
]

@pulumi.output_type
class GetReplicationSchedulesResult:
    """
    A collection of values returned by getReplicationSchedules.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, replication_schedule_collections=None, replication_schedule_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if replication_schedule_collections and not isinstance(replication_schedule_collections, list):
            raise TypeError("Expected argument 'replication_schedule_collections' to be a list")
        pulumi.set(__self__, "replication_schedule_collections", replication_schedule_collections)
        if replication_schedule_id and not isinstance(replication_schedule_id, str):
            raise TypeError("Expected argument 'replication_schedule_id' to be a str")
        pulumi.set(__self__, "replication_schedule_id", replication_schedule_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the replication schedule exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A name of the replication schedule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReplicationSchedulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="replicationScheduleCollections")
    def replication_schedule_collections(self) -> Sequence['outputs.GetReplicationSchedulesReplicationScheduleCollectionResult']:
        """
        The list of replication_schedule_collection.
        """
        return pulumi.get(self, "replication_schedule_collections")

    @property
    @pulumi.getter(name="replicationScheduleId")
    def replication_schedule_id(self) -> Optional[str]:
        return pulumi.get(self, "replication_schedule_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Current state of the replication schedule.
        """
        return pulumi.get(self, "state")


class AwaitableGetReplicationSchedulesResult(GetReplicationSchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationSchedulesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            replication_schedule_collections=self.replication_schedule_collections,
            replication_schedule_id=self.replication_schedule_id,
            state=self.state)


def get_replication_schedules(compartment_id: Optional[str] = None,
                              display_name: Optional[str] = None,
                              filters: Optional[Sequence[pulumi.InputType['GetReplicationSchedulesFilterArgs']]] = None,
                              replication_schedule_id: Optional[str] = None,
                              state: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationSchedulesResult:
    """
    This data source provides the list of Replication Schedules in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of replication schedules.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_schedules = oci.CloudMigrations.get_replication_schedules(compartment_id=compartment_id,
        display_name=replication_schedule_display_name,
        replication_schedule_id=test_replication_schedule["id"],
        state=replication_schedule_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str replication_schedule_id: Unique replication schedule identifier in query
    :param str state: The current state of the replication schedule.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['replicationScheduleId'] = replication_schedule_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getReplicationSchedules:getReplicationSchedules', __args__, opts=opts, typ=GetReplicationSchedulesResult).value

    return AwaitableGetReplicationSchedulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        replication_schedule_collections=pulumi.get(__ret__, 'replication_schedule_collections'),
        replication_schedule_id=pulumi.get(__ret__, 'replication_schedule_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_replication_schedules)
def get_replication_schedules_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetReplicationSchedulesFilterArgs']]]]] = None,
                                     replication_schedule_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReplicationSchedulesResult]:
    """
    This data source provides the list of Replication Schedules in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of replication schedules.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_schedules = oci.CloudMigrations.get_replication_schedules(compartment_id=compartment_id,
        display_name=replication_schedule_display_name,
        replication_schedule_id=test_replication_schedule["id"],
        state=replication_schedule_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str replication_schedule_id: Unique replication schedule identifier in query
    :param str state: The current state of the replication schedule.
    """
    ...
