# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClusterWorkloadMappingsResult',
    'AwaitableGetClusterWorkloadMappingsResult',
    'get_cluster_workload_mappings',
    'get_cluster_workload_mappings_output',
]

@pulumi.output_type
class GetClusterWorkloadMappingsResult:
    """
    A collection of values returned by getClusterWorkloadMappings.
    """
    def __init__(__self__, cluster_id=None, filters=None, id=None, workload_mappings=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if workload_mappings and not isinstance(workload_mappings, list):
            raise TypeError("Expected argument 'workload_mappings' to be a list")
        pulumi.set(__self__, "workload_mappings", workload_mappings)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetClusterWorkloadMappingsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="workloadMappings")
    def workload_mappings(self) -> Sequence['outputs.GetClusterWorkloadMappingsWorkloadMappingResult']:
        """
        The list of workload_mappings.
        """
        return pulumi.get(self, "workload_mappings")


class AwaitableGetClusterWorkloadMappingsResult(GetClusterWorkloadMappingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterWorkloadMappingsResult(
            cluster_id=self.cluster_id,
            filters=self.filters,
            id=self.id,
            workload_mappings=self.workload_mappings)


def get_cluster_workload_mappings(cluster_id: Optional[str] = None,
                                  filters: Optional[Sequence[pulumi.InputType['GetClusterWorkloadMappingsFilterArgs']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterWorkloadMappingsResult:
    """
    This data source provides the list of Cluster Workload Mappings in Oracle Cloud Infrastructure Container Engine service.

    List workloadMappings for a provisioned cluster.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_workload_mappings = oci.ContainerEngine.get_cluster_workload_mappings(cluster_id=test_cluster["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cluster_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getClusterWorkloadMappings:getClusterWorkloadMappings', __args__, opts=opts, typ=GetClusterWorkloadMappingsResult).value

    return AwaitableGetClusterWorkloadMappingsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        workload_mappings=pulumi.get(__ret__, 'workload_mappings'))


@_utilities.lift_output_func(get_cluster_workload_mappings)
def get_cluster_workload_mappings_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetClusterWorkloadMappingsFilterArgs']]]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterWorkloadMappingsResult]:
    """
    This data source provides the list of Cluster Workload Mappings in Oracle Cloud Infrastructure Container Engine service.

    List workloadMappings for a provisioned cluster.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_workload_mappings = oci.ContainerEngine.get_cluster_workload_mappings(cluster_id=test_cluster["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cluster_id: The OCID of the cluster.
    """
    ...
