# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterNetworkArgs', 'ClusterNetwork']

@pulumi.input_type
class ClusterNetworkArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 instance_pools: pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]],
                 placement_configuration: pulumi.Input['ClusterNetworkPlacementConfigurationArgs'],
                 cluster_configuration: Optional[pulumi.Input['ClusterNetworkClusterConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ClusterNetwork resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]] instance_pools: (Updatable) The data to create the instance pools in the cluster network.
               
               Each cluster network can have one instance pool.
        :param pulumi.Input['ClusterNetworkPlacementConfigurationArgs'] placement_configuration: The location for where the instance pools in a cluster network will place instances.
        :param pulumi.Input['ClusterNetworkClusterConfigurationArgs'] cluster_configuration: The HPC cluster configuration requested when launching instances of a cluster network.
               
               If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "instance_pools", instance_pools)
        pulumi.set(__self__, "placement_configuration", placement_configuration)
        if cluster_configuration is not None:
            pulumi.set(__self__, "cluster_configuration", cluster_configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="instancePools")
    def instance_pools(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]]:
        """
        (Updatable) The data to create the instance pools in the cluster network.

        Each cluster network can have one instance pool.
        """
        return pulumi.get(self, "instance_pools")

    @instance_pools.setter
    def instance_pools(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]]):
        pulumi.set(self, "instance_pools", value)

    @property
    @pulumi.getter(name="placementConfiguration")
    def placement_configuration(self) -> pulumi.Input['ClusterNetworkPlacementConfigurationArgs']:
        """
        The location for where the instance pools in a cluster network will place instances.
        """
        return pulumi.get(self, "placement_configuration")

    @placement_configuration.setter
    def placement_configuration(self, value: pulumi.Input['ClusterNetworkPlacementConfigurationArgs']):
        pulumi.set(self, "placement_configuration", value)

    @property
    @pulumi.getter(name="clusterConfiguration")
    def cluster_configuration(self) -> Optional[pulumi.Input['ClusterNetworkClusterConfigurationArgs']]:
        """
        The HPC cluster configuration requested when launching instances of a cluster network.

        If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        """
        return pulumi.get(self, "cluster_configuration")

    @cluster_configuration.setter
    def cluster_configuration(self, value: Optional[pulumi.Input['ClusterNetworkClusterConfigurationArgs']]):
        pulumi.set(self, "cluster_configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ClusterNetworkState:
    def __init__(__self__, *,
                 cluster_configuration: Optional[pulumi.Input['ClusterNetworkClusterConfigurationArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hpc_island_id: Optional[pulumi.Input[str]] = None,
                 instance_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]]] = None,
                 network_block_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_configuration: Optional[pulumi.Input['ClusterNetworkPlacementConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ClusterNetwork resources.
        :param pulumi.Input['ClusterNetworkClusterConfigurationArgs'] cluster_configuration: The HPC cluster configuration requested when launching instances of a cluster network.
               
               If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the HPC island.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]] instance_pools: (Updatable) The data to create the instance pools in the cluster network.
               
               Each cluster network can have one instance pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_block_ids: The list of network block OCIDs.
        :param pulumi.Input['ClusterNetworkPlacementConfigurationArgs'] placement_configuration: The location for where the instance pools in a cluster network will place instances.
        :param pulumi.Input[str] state: The current state of the cluster network.
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the resource was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if cluster_configuration is not None:
            pulumi.set(__self__, "cluster_configuration", cluster_configuration)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hpc_island_id is not None:
            pulumi.set(__self__, "hpc_island_id", hpc_island_id)
        if instance_pools is not None:
            pulumi.set(__self__, "instance_pools", instance_pools)
        if network_block_ids is not None:
            pulumi.set(__self__, "network_block_ids", network_block_ids)
        if placement_configuration is not None:
            pulumi.set(__self__, "placement_configuration", placement_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterConfiguration")
    def cluster_configuration(self) -> Optional[pulumi.Input['ClusterNetworkClusterConfigurationArgs']]:
        """
        The HPC cluster configuration requested when launching instances of a cluster network.

        If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        """
        return pulumi.get(self, "cluster_configuration")

    @cluster_configuration.setter
    def cluster_configuration(self, value: Optional[pulumi.Input['ClusterNetworkClusterConfigurationArgs']]):
        pulumi.set(self, "cluster_configuration", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hpcIslandId")
    def hpc_island_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the HPC island.
        """
        return pulumi.get(self, "hpc_island_id")

    @hpc_island_id.setter
    def hpc_island_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_island_id", value)

    @property
    @pulumi.getter(name="instancePools")
    def instance_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]]]:
        """
        (Updatable) The data to create the instance pools in the cluster network.

        Each cluster network can have one instance pool.
        """
        return pulumi.get(self, "instance_pools")

    @instance_pools.setter
    def instance_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNetworkInstancePoolArgs']]]]):
        pulumi.set(self, "instance_pools", value)

    @property
    @pulumi.getter(name="networkBlockIds")
    def network_block_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of network block OCIDs.
        """
        return pulumi.get(self, "network_block_ids")

    @network_block_ids.setter
    def network_block_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_block_ids", value)

    @property
    @pulumi.getter(name="placementConfiguration")
    def placement_configuration(self) -> Optional[pulumi.Input['ClusterNetworkPlacementConfigurationArgs']]:
        """
        The location for where the instance pools in a cluster network will place instances.
        """
        return pulumi.get(self, "placement_configuration")

    @placement_configuration.setter
    def placement_configuration(self, value: Optional[pulumi.Input['ClusterNetworkPlacementConfigurationArgs']]):
        pulumi.set(self, "placement_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the cluster network.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class ClusterNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_configuration: Optional[pulumi.Input[pulumi.InputType['ClusterNetworkClusterConfigurationArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNetworkInstancePoolArgs']]]]] = None,
                 placement_configuration: Optional[pulumi.Input[pulumi.InputType['ClusterNetworkPlacementConfigurationArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Cluster Network resource in Oracle Cloud Infrastructure Core service.

        Creates a [cluster network with instance pools](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingclusternetworks.htm).
        A cluster network is a group of high performance computing (HPC), GPU, or optimized bare metal
        instances that are connected with an ultra low-latency remote direct memory access (RDMA) network.
        Cluster networks with instance pools use instance pools to manage groups of identical instances.

        Use cluster networks with instance pools when you want predictable capacity for a specific number of identical
        instances that are managed as a group.

        If you want to manage instances in the RDMA network independently of each other or use different types of instances
        in the network group, create a compute cluster by using the [CreateComputeCluster](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCluster/CreateComputeCluster)
        operation.

        To determine whether capacity is available for a specific shape before you create a cluster network,
        use the [CreateComputeCapacityReport](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCapacityReport/CreateComputeCapacityReport)
        operation.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster_network = oci.core.ClusterNetwork("test_cluster_network",
            compartment_id=compartment_id,
            instance_pools=[oci.core.ClusterNetworkInstancePoolArgs(
                instance_configuration_id=test_instance_configuration["id"],
                size=cluster_network_instance_pools_size,
                defined_tags={
                    "Operations.CostCenter": "42",
                },
                display_name=cluster_network_instance_pools_display_name,
                freeform_tags={
                    "Department": "Finance",
                },
            )],
            placement_configuration=oci.core.ClusterNetworkPlacementConfigurationArgs(
                availability_domain=cluster_network_placement_configuration_availability_domain,
                primary_vnic_subnets=oci.core.ClusterNetworkPlacementConfigurationPrimaryVnicSubnetsArgs(
                    subnet_id=test_subnet["id"],
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.ClusterNetworkPlacementConfigurationPrimaryVnicSubnetsIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=cluster_network_placement_configuration_primary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                    )],
                    is_assign_ipv6ip=cluster_network_placement_configuration_primary_vnic_subnets_is_assign_ipv6ip,
                ),
                secondary_vnic_subnets=[oci.core.ClusterNetworkPlacementConfigurationSecondaryVnicSubnetArgs(
                    subnet_id=test_subnet["id"],
                    display_name=cluster_network_placement_configuration_secondary_vnic_subnets_display_name,
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.ClusterNetworkPlacementConfigurationSecondaryVnicSubnetIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=cluster_network_placement_configuration_secondary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                    )],
                    is_assign_ipv6ip=cluster_network_placement_configuration_secondary_vnic_subnets_is_assign_ipv6ip,
                )],
            ),
            cluster_configuration=oci.core.ClusterNetworkClusterConfigurationArgs(
                hpc_island_id=test_hpc_island["id"],
                network_block_ids=cluster_network_cluster_configuration_network_block_ids,
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cluster_network_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ClusterNetworks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/clusterNetwork:ClusterNetwork test_cluster_network "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterNetworkClusterConfigurationArgs']] cluster_configuration: The HPC cluster configuration requested when launching instances of a cluster network.
               
               If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNetworkInstancePoolArgs']]]] instance_pools: (Updatable) The data to create the instance pools in the cluster network.
               
               Each cluster network can have one instance pool.
        :param pulumi.Input[pulumi.InputType['ClusterNetworkPlacementConfigurationArgs']] placement_configuration: The location for where the instance pools in a cluster network will place instances.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cluster Network resource in Oracle Cloud Infrastructure Core service.

        Creates a [cluster network with instance pools](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingclusternetworks.htm).
        A cluster network is a group of high performance computing (HPC), GPU, or optimized bare metal
        instances that are connected with an ultra low-latency remote direct memory access (RDMA) network.
        Cluster networks with instance pools use instance pools to manage groups of identical instances.

        Use cluster networks with instance pools when you want predictable capacity for a specific number of identical
        instances that are managed as a group.

        If you want to manage instances in the RDMA network independently of each other or use different types of instances
        in the network group, create a compute cluster by using the [CreateComputeCluster](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCluster/CreateComputeCluster)
        operation.

        To determine whether capacity is available for a specific shape before you create a cluster network,
        use the [CreateComputeCapacityReport](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCapacityReport/CreateComputeCapacityReport)
        operation.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster_network = oci.core.ClusterNetwork("test_cluster_network",
            compartment_id=compartment_id,
            instance_pools=[oci.core.ClusterNetworkInstancePoolArgs(
                instance_configuration_id=test_instance_configuration["id"],
                size=cluster_network_instance_pools_size,
                defined_tags={
                    "Operations.CostCenter": "42",
                },
                display_name=cluster_network_instance_pools_display_name,
                freeform_tags={
                    "Department": "Finance",
                },
            )],
            placement_configuration=oci.core.ClusterNetworkPlacementConfigurationArgs(
                availability_domain=cluster_network_placement_configuration_availability_domain,
                primary_vnic_subnets=oci.core.ClusterNetworkPlacementConfigurationPrimaryVnicSubnetsArgs(
                    subnet_id=test_subnet["id"],
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.ClusterNetworkPlacementConfigurationPrimaryVnicSubnetsIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=cluster_network_placement_configuration_primary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                    )],
                    is_assign_ipv6ip=cluster_network_placement_configuration_primary_vnic_subnets_is_assign_ipv6ip,
                ),
                secondary_vnic_subnets=[oci.core.ClusterNetworkPlacementConfigurationSecondaryVnicSubnetArgs(
                    subnet_id=test_subnet["id"],
                    display_name=cluster_network_placement_configuration_secondary_vnic_subnets_display_name,
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.ClusterNetworkPlacementConfigurationSecondaryVnicSubnetIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=cluster_network_placement_configuration_secondary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                    )],
                    is_assign_ipv6ip=cluster_network_placement_configuration_secondary_vnic_subnets_is_assign_ipv6ip,
                )],
            ),
            cluster_configuration=oci.core.ClusterNetworkClusterConfigurationArgs(
                hpc_island_id=test_hpc_island["id"],
                network_block_ids=cluster_network_cluster_configuration_network_block_ids,
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cluster_network_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ClusterNetworks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/clusterNetwork:ClusterNetwork test_cluster_network "id"
        ```

        :param str resource_name: The name of the resource.
        :param ClusterNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_configuration: Optional[pulumi.Input[pulumi.InputType['ClusterNetworkClusterConfigurationArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNetworkInstancePoolArgs']]]]] = None,
                 placement_configuration: Optional[pulumi.Input[pulumi.InputType['ClusterNetworkPlacementConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterNetworkArgs.__new__(ClusterNetworkArgs)

            __props__.__dict__["cluster_configuration"] = cluster_configuration
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if instance_pools is None and not opts.urn:
                raise TypeError("Missing required property 'instance_pools'")
            __props__.__dict__["instance_pools"] = instance_pools
            if placement_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'placement_configuration'")
            __props__.__dict__["placement_configuration"] = placement_configuration
            __props__.__dict__["hpc_island_id"] = None
            __props__.__dict__["network_block_ids"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ClusterNetwork, __self__).__init__(
            'oci:Core/clusterNetwork:ClusterNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_configuration: Optional[pulumi.Input[pulumi.InputType['ClusterNetworkClusterConfigurationArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            hpc_island_id: Optional[pulumi.Input[str]] = None,
            instance_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNetworkInstancePoolArgs']]]]] = None,
            network_block_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            placement_configuration: Optional[pulumi.Input[pulumi.InputType['ClusterNetworkPlacementConfigurationArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'ClusterNetwork':
        """
        Get an existing ClusterNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterNetworkClusterConfigurationArgs']] cluster_configuration: The HPC cluster configuration requested when launching instances of a cluster network.
               
               If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the HPC island.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNetworkInstancePoolArgs']]]] instance_pools: (Updatable) The data to create the instance pools in the cluster network.
               
               Each cluster network can have one instance pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_block_ids: The list of network block OCIDs.
        :param pulumi.Input[pulumi.InputType['ClusterNetworkPlacementConfigurationArgs']] placement_configuration: The location for where the instance pools in a cluster network will place instances.
        :param pulumi.Input[str] state: The current state of the cluster network.
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the resource was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterNetworkState.__new__(_ClusterNetworkState)

        __props__.__dict__["cluster_configuration"] = cluster_configuration
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hpc_island_id"] = hpc_island_id
        __props__.__dict__["instance_pools"] = instance_pools
        __props__.__dict__["network_block_ids"] = network_block_ids
        __props__.__dict__["placement_configuration"] = placement_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ClusterNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterConfiguration")
    def cluster_configuration(self) -> pulumi.Output['outputs.ClusterNetworkClusterConfiguration']:
        """
        The HPC cluster configuration requested when launching instances of a cluster network.

        If the parameter is provided, instances will only be placed within the HPC island and list of network blocks  that you specify. If a list of network blocks are missing or not provided, the instances will be placed in any  HPC blocks in the HPC island that you specify. If the values of HPC island or network block that you provide are  not valid, an error is returned.
        """
        return pulumi.get(self, "cluster_configuration")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hpcIslandId")
    def hpc_island_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the HPC island.
        """
        return pulumi.get(self, "hpc_island_id")

    @property
    @pulumi.getter(name="instancePools")
    def instance_pools(self) -> pulumi.Output[Sequence['outputs.ClusterNetworkInstancePool']]:
        """
        (Updatable) The data to create the instance pools in the cluster network.

        Each cluster network can have one instance pool.
        """
        return pulumi.get(self, "instance_pools")

    @property
    @pulumi.getter(name="networkBlockIds")
    def network_block_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of network block OCIDs.
        """
        return pulumi.get(self, "network_block_ids")

    @property
    @pulumi.getter(name="placementConfiguration")
    def placement_configuration(self) -> pulumi.Output['outputs.ClusterNetworkPlacementConfiguration']:
        """
        The location for where the instance pools in a cluster network will place instances.
        """
        return pulumi.get(self, "placement_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the cluster network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the resource was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

