# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBootVolumesResult',
    'AwaitableGetBootVolumesResult',
    'get_boot_volumes',
    'get_boot_volumes_output',
]

@pulumi.output_type
class GetBootVolumesResult:
    """
    A collection of values returned by getBootVolumes.
    """
    def __init__(__self__, availability_domain=None, boot_volumes=None, compartment_id=None, filters=None, id=None, volume_group_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if boot_volumes and not isinstance(boot_volumes, list):
            raise TypeError("Expected argument 'boot_volumes' to be a list")
        pulumi.set(__self__, "boot_volumes", boot_volumes)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if volume_group_id and not isinstance(volume_group_id, str):
            raise TypeError("Expected argument 'volume_group_id' to be a str")
        pulumi.set(__self__, "volume_group_id", volume_group_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain of the boot volume replica.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bootVolumes")
    def boot_volumes(self) -> Sequence['outputs.GetBootVolumesBootVolumeResult']:
        """
        The list of boot_volumes.
        """
        return pulumi.get(self, "boot_volumes")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment that contains the boot volume.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBootVolumesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> Optional[str]:
        """
        The OCID of the source volume group.
        """
        return pulumi.get(self, "volume_group_id")


class AwaitableGetBootVolumesResult(GetBootVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBootVolumesResult(
            availability_domain=self.availability_domain,
            boot_volumes=self.boot_volumes,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            volume_group_id=self.volume_group_id)


def get_boot_volumes(availability_domain: Optional[str] = None,
                     compartment_id: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetBootVolumesFilterArgs']]] = None,
                     volume_group_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBootVolumesResult:
    """
    This data source provides the list of Boot Volumes in Oracle Cloud Infrastructure Core service.

    Lists the boot volumes in the specified compartment and availability domain.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volumes = oci.Core.get_boot_volumes(availability_domain=boot_volume_availability_domain,
        compartment_id=compartment_id,
        volume_group_id=test_volume_group["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str volume_group_id: The OCID of the volume group.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['volumeGroupId'] = volume_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getBootVolumes:getBootVolumes', __args__, opts=opts, typ=GetBootVolumesResult).value

    return AwaitableGetBootVolumesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        boot_volumes=pulumi.get(__ret__, 'boot_volumes'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        volume_group_id=pulumi.get(__ret__, 'volume_group_id'))


@_utilities.lift_output_func(get_boot_volumes)
def get_boot_volumes_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                            compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetBootVolumesFilterArgs']]]]] = None,
                            volume_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBootVolumesResult]:
    """
    This data source provides the list of Boot Volumes in Oracle Cloud Infrastructure Core service.

    Lists the boot volumes in the specified compartment and availability domain.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volumes = oci.Core.get_boot_volumes(availability_domain=boot_volume_availability_domain,
        compartment_id=compartment_id,
        volume_group_id=test_volume_group["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str volume_group_id: The OCID of the volume group.
    """
    ...
