# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetComputeCapacityReservationResult',
    'AwaitableGetComputeCapacityReservationResult',
    'get_compute_capacity_reservation',
    'get_compute_capacity_reservation_output',
]

@pulumi.output_type
class GetComputeCapacityReservationResult:
    """
    A collection of values returned by getComputeCapacityReservation.
    """
    def __init__(__self__, availability_domain=None, capacity_reservation_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, instance_reservation_configs=None, is_default_reservation=None, reserved_instance_count=None, state=None, time_created=None, time_updated=None, used_instance_count=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_reservation_id and not isinstance(capacity_reservation_id, str):
            raise TypeError("Expected argument 'capacity_reservation_id' to be a str")
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_reservation_configs and not isinstance(instance_reservation_configs, list):
            raise TypeError("Expected argument 'instance_reservation_configs' to be a list")
        pulumi.set(__self__, "instance_reservation_configs", instance_reservation_configs)
        if is_default_reservation and not isinstance(is_default_reservation, bool):
            raise TypeError("Expected argument 'is_default_reservation' to be a bool")
        pulumi.set(__self__, "is_default_reservation", is_default_reservation)
        if reserved_instance_count and not isinstance(reserved_instance_count, str):
            raise TypeError("Expected argument 'reserved_instance_count' to be a str")
        pulumi.set(__self__, "reserved_instance_count", reserved_instance_count)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if used_instance_count and not isinstance(used_instance_count, str):
            raise TypeError("Expected argument 'used_instance_count' to be a str")
        pulumi.set(__self__, "used_instance_count", used_instance_count)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain of the compute capacity reservation.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the compute capacity reservation.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity reservation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceReservationConfigs")
    def instance_reservation_configs(self) -> Sequence['outputs.GetComputeCapacityReservationInstanceReservationConfigResult']:
        """
        The capacity configurations for the capacity reservation.
        """
        return pulumi.get(self, "instance_reservation_configs")

    @property
    @pulumi.getter(name="isDefaultReservation")
    def is_default_reservation(self) -> bool:
        """
        Whether this capacity reservation is the default. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        """
        return pulumi.get(self, "is_default_reservation")

    @property
    @pulumi.getter(name="reservedInstanceCount")
    def reserved_instance_count(self) -> str:
        """
        The number of instances for which capacity will be held with this compute capacity reservation. This number is the sum of the values of the `reservedCount` fields for all of the instance capacity configurations under this reservation. The purpose of this field is to calculate the percentage usage of the reservation.
        """
        return pulumi.get(self, "reserved_instance_count")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the compute capacity reservation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the compute capacity reservation was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the compute capacity reservation was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="usedInstanceCount")
    def used_instance_count(self) -> str:
        """
        The total number of instances currently consuming space in this compute capacity reservation. This number is the sum of the values of the `usedCount` fields for all of the instance capacity configurations under this reservation. The purpose of this field is to calculate the percentage usage of the reservation.
        """
        return pulumi.get(self, "used_instance_count")


class AwaitableGetComputeCapacityReservationResult(GetComputeCapacityReservationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeCapacityReservationResult(
            availability_domain=self.availability_domain,
            capacity_reservation_id=self.capacity_reservation_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            instance_reservation_configs=self.instance_reservation_configs,
            is_default_reservation=self.is_default_reservation,
            reserved_instance_count=self.reserved_instance_count,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            used_instance_count=self.used_instance_count)


def get_compute_capacity_reservation(capacity_reservation_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeCapacityReservationResult:
    """
    This data source provides details about a specific Compute Capacity Reservation resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute capacity reservation.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_reservation = oci.Core.get_compute_capacity_reservation(capacity_reservation_id=test_capacity_reservation["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str capacity_reservation_id: The OCID of the compute capacity reservation.
    """
    __args__ = dict()
    __args__['capacityReservationId'] = capacity_reservation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeCapacityReservation:getComputeCapacityReservation', __args__, opts=opts, typ=GetComputeCapacityReservationResult).value

    return AwaitableGetComputeCapacityReservationResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capacity_reservation_id=pulumi.get(__ret__, 'capacity_reservation_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        instance_reservation_configs=pulumi.get(__ret__, 'instance_reservation_configs'),
        is_default_reservation=pulumi.get(__ret__, 'is_default_reservation'),
        reserved_instance_count=pulumi.get(__ret__, 'reserved_instance_count'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        used_instance_count=pulumi.get(__ret__, 'used_instance_count'))


@_utilities.lift_output_func(get_compute_capacity_reservation)
def get_compute_capacity_reservation_output(capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetComputeCapacityReservationResult]:
    """
    This data source provides details about a specific Compute Capacity Reservation resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute capacity reservation.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_reservation = oci.Core.get_compute_capacity_reservation(capacity_reservation_id=test_capacity_reservation["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str capacity_reservation_id: The OCID of the compute capacity reservation.
    """
    ...
