# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrgAttachmentsResult',
    'AwaitableGetDrgAttachmentsResult',
    'get_drg_attachments',
    'get_drg_attachments_output',
]

@pulumi.output_type
class GetDrgAttachmentsResult:
    """
    A collection of values returned by getDrgAttachments.
    """
    def __init__(__self__, attachment_type=None, compartment_id=None, display_name=None, drg_attachments=None, drg_id=None, drg_route_table_id=None, filters=None, id=None, network_id=None, state=None, vcn_id=None):
        if attachment_type and not isinstance(attachment_type, str):
            raise TypeError("Expected argument 'attachment_type' to be a str")
        pulumi.set(__self__, "attachment_type", attachment_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if drg_attachments and not isinstance(drg_attachments, list):
            raise TypeError("Expected argument 'drg_attachments' to be a list")
        pulumi.set(__self__, "drg_attachments", drg_attachments)
        if drg_id and not isinstance(drg_id, str):
            raise TypeError("Expected argument 'drg_id' to be a str")
        pulumi.set(__self__, "drg_id", drg_id)
        if drg_route_table_id and not isinstance(drg_route_table_id, str):
            raise TypeError("Expected argument 'drg_route_table_id' to be a str")
        pulumi.set(__self__, "drg_route_table_id", drg_route_table_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[str]:
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the DRG attachment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drgAttachments")
    def drg_attachments(self) -> Sequence['outputs.GetDrgAttachmentsDrgAttachmentResult']:
        """
        The list of drg_attachments.
        """
        return pulumi.get(self, "drg_attachments")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="drgRouteTableId")
    def drg_route_table_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table that is assigned to this attachment.
        """
        return pulumi.get(self, "drg_route_table_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrgAttachmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[str]:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The DRG attachment's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN. This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetDrgAttachmentsResult(GetDrgAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrgAttachmentsResult(
            attachment_type=self.attachment_type,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            drg_attachments=self.drg_attachments,
            drg_id=self.drg_id,
            drg_route_table_id=self.drg_route_table_id,
            filters=self.filters,
            id=self.id,
            network_id=self.network_id,
            state=self.state,
            vcn_id=self.vcn_id)


def get_drg_attachments(attachment_type: Optional[str] = None,
                        compartment_id: Optional[str] = None,
                        display_name: Optional[str] = None,
                        drg_id: Optional[str] = None,
                        drg_route_table_id: Optional[str] = None,
                        filters: Optional[Sequence[pulumi.InputType['GetDrgAttachmentsFilterArgs']]] = None,
                        network_id: Optional[str] = None,
                        state: Optional[str] = None,
                        vcn_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrgAttachmentsResult:
    """
    This data source provides the list of Drg Attachments in Oracle Cloud Infrastructure Core service.

    Lists the `DrgAttachment` resource for the specified compartment. You can filter the
    results by DRG, attached network, attachment type, DRG route table or
    VCN route table.

    The LIST API lists DRG attachments by attachment type. It will default to list VCN attachments,
    but you may request to list ALL attachments of ALL types.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_attachments = oci.Core.get_drg_attachments(compartment_id=compartment_id,
        attachment_type=drg_attachment_attachment_type,
        display_name=drg_attachment_display_name,
        drg_id=test_drg["id"],
        drg_route_table_id=test_drg_route_table["id"],
        network_id=test_network["id"],
        state=drg_attachment_state,
        vcn_id=test_vcn["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str attachment_type: The type for the network resource attached to the DRG.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    :param str drg_route_table_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
    :param str network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['attachmentType'] = attachment_type
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['drgId'] = drg_id
    __args__['drgRouteTableId'] = drg_route_table_id
    __args__['filters'] = filters
    __args__['networkId'] = network_id
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDrgAttachments:getDrgAttachments', __args__, opts=opts, typ=GetDrgAttachmentsResult).value

    return AwaitableGetDrgAttachmentsResult(
        attachment_type=pulumi.get(__ret__, 'attachment_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        drg_attachments=pulumi.get(__ret__, 'drg_attachments'),
        drg_id=pulumi.get(__ret__, 'drg_id'),
        drg_route_table_id=pulumi.get(__ret__, 'drg_route_table_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        network_id=pulumi.get(__ret__, 'network_id'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))


@_utilities.lift_output_func(get_drg_attachments)
def get_drg_attachments_output(attachment_type: Optional[pulumi.Input[Optional[str]]] = None,
                               compartment_id: Optional[pulumi.Input[str]] = None,
                               display_name: Optional[pulumi.Input[Optional[str]]] = None,
                               drg_id: Optional[pulumi.Input[Optional[str]]] = None,
                               drg_route_table_id: Optional[pulumi.Input[Optional[str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDrgAttachmentsFilterArgs']]]]] = None,
                               network_id: Optional[pulumi.Input[Optional[str]]] = None,
                               state: Optional[pulumi.Input[Optional[str]]] = None,
                               vcn_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrgAttachmentsResult]:
    """
    This data source provides the list of Drg Attachments in Oracle Cloud Infrastructure Core service.

    Lists the `DrgAttachment` resource for the specified compartment. You can filter the
    results by DRG, attached network, attachment type, DRG route table or
    VCN route table.

    The LIST API lists DRG attachments by attachment type. It will default to list VCN attachments,
    but you may request to list ALL attachments of ALL types.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_attachments = oci.Core.get_drg_attachments(compartment_id=compartment_id,
        attachment_type=drg_attachment_attachment_type,
        display_name=drg_attachment_display_name,
        drg_id=test_drg["id"],
        drg_route_table_id=test_drg_route_table["id"],
        network_id=test_network["id"],
        state=drg_attachment_state,
        vcn_id=test_vcn["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str attachment_type: The type for the network resource attached to the DRG.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    :param str drg_route_table_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
    :param str network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    ...
