# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrgRouteDistributionsResult',
    'AwaitableGetDrgRouteDistributionsResult',
    'get_drg_route_distributions',
    'get_drg_route_distributions_output',
]

@pulumi.output_type
class GetDrgRouteDistributionsResult:
    """
    A collection of values returned by getDrgRouteDistributions.
    """
    def __init__(__self__, display_name=None, drg_id=None, drg_route_distributions=None, filters=None, id=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if drg_id and not isinstance(drg_id, str):
            raise TypeError("Expected argument 'drg_id' to be a str")
        pulumi.set(__self__, "drg_id", drg_id)
        if drg_route_distributions and not isinstance(drg_route_distributions, list):
            raise TypeError("Expected argument 'drg_route_distributions' to be a list")
        pulumi.set(__self__, "drg_route_distributions", drg_route_distributions)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG that contains this route distribution.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="drgRouteDistributions")
    def drg_route_distributions(self) -> Sequence['outputs.GetDrgRouteDistributionsDrgRouteDistributionResult']:
        """
        The list of drg_route_distributions.
        """
        return pulumi.get(self, "drg_route_distributions")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrgRouteDistributionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The route distribution's current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetDrgRouteDistributionsResult(GetDrgRouteDistributionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrgRouteDistributionsResult(
            display_name=self.display_name,
            drg_id=self.drg_id,
            drg_route_distributions=self.drg_route_distributions,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_drg_route_distributions(display_name: Optional[str] = None,
                                drg_id: Optional[str] = None,
                                filters: Optional[Sequence[pulumi.InputType['GetDrgRouteDistributionsFilterArgs']]] = None,
                                state: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrgRouteDistributionsResult:
    """
    This data source provides the list of Drg Route Distributions in Oracle Cloud Infrastructure Core service.

    Lists the route distributions in the specified DRG.

    To retrieve the statements in a distribution, use the
    ListDrgRouteDistributionStatements operation.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_distributions = oci.Core.get_drg_route_distributions(drg_id=test_drg["id"],
        display_name=drg_route_distribution_display_name,
        state=drg_route_distribution_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    :param str state: A filter that only returns resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drgId'] = drg_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDrgRouteDistributions:getDrgRouteDistributions', __args__, opts=opts, typ=GetDrgRouteDistributionsResult).value

    return AwaitableGetDrgRouteDistributionsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        drg_id=pulumi.get(__ret__, 'drg_id'),
        drg_route_distributions=pulumi.get(__ret__, 'drg_route_distributions'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_drg_route_distributions)
def get_drg_route_distributions_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                       drg_id: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDrgRouteDistributionsFilterArgs']]]]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrgRouteDistributionsResult]:
    """
    This data source provides the list of Drg Route Distributions in Oracle Cloud Infrastructure Core service.

    Lists the route distributions in the specified DRG.

    To retrieve the statements in a distribution, use the
    ListDrgRouteDistributionStatements operation.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_distributions = oci.Core.get_drg_route_distributions(drg_id=test_drg["id"],
        display_name=drg_route_distribution_display_name,
        state=drg_route_distribution_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    :param str state: A filter that only returns resources that match the specified lifecycle state. The value is case insensitive.
    """
    ...
