# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceConfigurationResult',
    'AwaitableGetInstanceConfigurationResult',
    'get_instance_configuration',
    'get_instance_configuration_output',
]

@pulumi.output_type
class GetInstanceConfigurationResult:
    """
    A collection of values returned by getInstanceConfiguration.
    """
    def __init__(__self__, compartment_id=None, deferred_fields=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, instance_configuration_id=None, instance_details=None, instance_id=None, source=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if deferred_fields and not isinstance(deferred_fields, list):
            raise TypeError("Expected argument 'deferred_fields' to be a list")
        pulumi.set(__self__, "deferred_fields", deferred_fields)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_configuration_id and not isinstance(instance_configuration_id, str):
            raise TypeError("Expected argument 'instance_configuration_id' to be a str")
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_details and not isinstance(instance_details, list):
            raise TypeError("Expected argument 'instance_details' to be a list")
        pulumi.set(__self__, "instance_details", instance_details)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing images to search
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deferredFields")
    def deferred_fields(self) -> Sequence[str]:
        """
        Parameters that were not specified when the instance configuration was created, but that are required to launch an instance from the instance configuration. See the [LaunchInstanceConfiguration](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstanceConfiguration) operation.
        """
        return pulumi.get(self, "deferred_fields")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the volume backup.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceDetails")
    def instance_details(self) -> Sequence['outputs.GetInstanceConfigurationInstanceDetailResult']:
        return pulumi.get(self, "instance_details")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the instance configuration was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetInstanceConfigurationResult(GetInstanceConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceConfigurationResult(
            compartment_id=self.compartment_id,
            deferred_fields=self.deferred_fields,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            instance_configuration_id=self.instance_configuration_id,
            instance_details=self.instance_details,
            instance_id=self.instance_id,
            source=self.source,
            time_created=self.time_created)


def get_instance_configuration(instance_configuration_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceConfigurationResult:
    """
    This data source provides details about a specific Instance Configuration resource in Oracle Cloud Infrastructure Core service.

    Gets the specified instance configuration

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_configuration = oci.Core.get_instance_configuration(instance_configuration_id=test_instance_configuration_oci_core_instance_configuration["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str instance_configuration_id: The OCID of the instance configuration.
    """
    __args__ = dict()
    __args__['instanceConfigurationId'] = instance_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstanceConfiguration:getInstanceConfiguration', __args__, opts=opts, typ=GetInstanceConfigurationResult).value

    return AwaitableGetInstanceConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        deferred_fields=pulumi.get(__ret__, 'deferred_fields'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        instance_configuration_id=pulumi.get(__ret__, 'instance_configuration_id'),
        instance_details=pulumi.get(__ret__, 'instance_details'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        source=pulumi.get(__ret__, 'source'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_instance_configuration)
def get_instance_configuration_output(instance_configuration_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceConfigurationResult]:
    """
    This data source provides details about a specific Instance Configuration resource in Oracle Cloud Infrastructure Core service.

    Gets the specified instance configuration

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_configuration = oci.Core.get_instance_configuration(instance_configuration_id=test_instance_configuration_oci_core_instance_configuration["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str instance_configuration_id: The OCID of the instance configuration.
    """
    ...
