# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetLetterOfAuthorityResult',
    'AwaitableGetLetterOfAuthorityResult',
    'get_letter_of_authority',
    'get_letter_of_authority_output',
]

@pulumi.output_type
class GetLetterOfAuthorityResult:
    """
    A collection of values returned by getLetterOfAuthority.
    """
    def __init__(__self__, authorized_entity_name=None, circuit_type=None, cross_connect_id=None, facility_location=None, id=None, port_name=None, time_expires=None, time_issued=None):
        if authorized_entity_name and not isinstance(authorized_entity_name, str):
            raise TypeError("Expected argument 'authorized_entity_name' to be a str")
        pulumi.set(__self__, "authorized_entity_name", authorized_entity_name)
        if circuit_type and not isinstance(circuit_type, str):
            raise TypeError("Expected argument 'circuit_type' to be a str")
        pulumi.set(__self__, "circuit_type", circuit_type)
        if cross_connect_id and not isinstance(cross_connect_id, str):
            raise TypeError("Expected argument 'cross_connect_id' to be a str")
        pulumi.set(__self__, "cross_connect_id", cross_connect_id)
        if facility_location and not isinstance(facility_location, str):
            raise TypeError("Expected argument 'facility_location' to be a str")
        pulumi.set(__self__, "facility_location", facility_location)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if port_name and not isinstance(port_name, str):
            raise TypeError("Expected argument 'port_name' to be a str")
        pulumi.set(__self__, "port_name", port_name)
        if time_expires and not isinstance(time_expires, str):
            raise TypeError("Expected argument 'time_expires' to be a str")
        pulumi.set(__self__, "time_expires", time_expires)
        if time_issued and not isinstance(time_issued, str):
            raise TypeError("Expected argument 'time_issued' to be a str")
        pulumi.set(__self__, "time_issued", time_issued)

    @property
    @pulumi.getter(name="authorizedEntityName")
    def authorized_entity_name(self) -> str:
        """
        The name of the entity authorized by this Letter of Authority.
        """
        return pulumi.get(self, "authorized_entity_name")

    @property
    @pulumi.getter(name="circuitType")
    def circuit_type(self) -> str:
        """
        The type of cross-connect fiber, termination, and optical specification.
        """
        return pulumi.get(self, "circuit_type")

    @property
    @pulumi.getter(name="crossConnectId")
    def cross_connect_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect.
        """
        return pulumi.get(self, "cross_connect_id")

    @property
    @pulumi.getter(name="facilityLocation")
    def facility_location(self) -> str:
        """
        The address of the FastConnect location.
        """
        return pulumi.get(self, "facility_location")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        The meet-me room port for this cross-connect.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> str:
        """
        The date and time when the Letter of Authority expires, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_expires")

    @property
    @pulumi.getter(name="timeIssued")
    def time_issued(self) -> str:
        """
        The date and time the Letter of Authority was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_issued")


class AwaitableGetLetterOfAuthorityResult(GetLetterOfAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLetterOfAuthorityResult(
            authorized_entity_name=self.authorized_entity_name,
            circuit_type=self.circuit_type,
            cross_connect_id=self.cross_connect_id,
            facility_location=self.facility_location,
            id=self.id,
            port_name=self.port_name,
            time_expires=self.time_expires,
            time_issued=self.time_issued)


def get_letter_of_authority(cross_connect_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLetterOfAuthorityResult:
    """
    This data source provides details about a specific Letter Of Authority resource in Oracle Cloud Infrastructure Core service.

    Gets the Letter of Authority for the specified cross-connect.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_letter_of_authority = oci.Core.get_letter_of_authority(cross_connect_id=test_cross_connect["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cross_connect_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect.
    """
    __args__ = dict()
    __args__['crossConnectId'] = cross_connect_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getLetterOfAuthority:getLetterOfAuthority', __args__, opts=opts, typ=GetLetterOfAuthorityResult).value

    return AwaitableGetLetterOfAuthorityResult(
        authorized_entity_name=pulumi.get(__ret__, 'authorized_entity_name'),
        circuit_type=pulumi.get(__ret__, 'circuit_type'),
        cross_connect_id=pulumi.get(__ret__, 'cross_connect_id'),
        facility_location=pulumi.get(__ret__, 'facility_location'),
        id=pulumi.get(__ret__, 'id'),
        port_name=pulumi.get(__ret__, 'port_name'),
        time_expires=pulumi.get(__ret__, 'time_expires'),
        time_issued=pulumi.get(__ret__, 'time_issued'))


@_utilities.lift_output_func(get_letter_of_authority)
def get_letter_of_authority_output(cross_connect_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLetterOfAuthorityResult]:
    """
    This data source provides details about a specific Letter Of Authority resource in Oracle Cloud Infrastructure Core service.

    Gets the Letter of Authority for the specified cross-connect.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_letter_of_authority = oci.Core.get_letter_of_authority(cross_connect_id=test_cross_connect["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cross_connect_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect.
    """
    ...
