# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceGatewaysResult',
    'AwaitableGetServiceGatewaysResult',
    'get_service_gateways',
    'get_service_gateways_output',
]

@pulumi.output_type
class GetServiceGatewaysResult:
    """
    A collection of values returned by getServiceGateways.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, service_gateways=None, state=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_gateways and not isinstance(service_gateways, list):
            raise TypeError("Expected argument 'service_gateways' to be a list")
        pulumi.set(__self__, "service_gateways", service_gateways)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the service gateway.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceGatewaysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceGateways")
    def service_gateways(self) -> Sequence['outputs.GetServiceGatewaysServiceGatewayResult']:
        """
        The list of service_gateways.
        """
        return pulumi.get(self, "service_gateways")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The service gateway's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the service gateway belongs to.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetServiceGatewaysResult(GetServiceGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceGatewaysResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            service_gateways=self.service_gateways,
            state=self.state,
            vcn_id=self.vcn_id)


def get_service_gateways(compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetServiceGatewaysFilterArgs']]] = None,
                         state: Optional[str] = None,
                         vcn_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceGatewaysResult:
    """
    This data source provides the list of Service Gateways in Oracle Cloud Infrastructure Core service.

    Lists the service gateways in the specified compartment. You may optionally specify a VCN OCID
    to filter the results by VCN.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_gateways = oci.Core.get_service_gateways(compartment_id=compartment_id,
        state=service_gateway_state,
        vcn_id=test_vcn["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getServiceGateways:getServiceGateways', __args__, opts=opts, typ=GetServiceGatewaysResult).value

    return AwaitableGetServiceGatewaysResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_gateways=pulumi.get(__ret__, 'service_gateways'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))


@_utilities.lift_output_func(get_service_gateways)
def get_service_gateways_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetServiceGatewaysFilterArgs']]]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                vcn_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceGatewaysResult]:
    """
    This data source provides the list of Service Gateways in Oracle Cloud Infrastructure Core service.

    Lists the service gateways in the specified compartment. You may optionally specify a VCN OCID
    to filter the results by VCN.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_gateways = oci.Core.get_service_gateways(compartment_id=compartment_id,
        state=service_gateway_state,
        vcn_id=test_vcn["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    ...
