# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualCircuitAssociatedTunnelsResult',
    'AwaitableGetVirtualCircuitAssociatedTunnelsResult',
    'get_virtual_circuit_associated_tunnels',
    'get_virtual_circuit_associated_tunnels_output',
]

@pulumi.output_type
class GetVirtualCircuitAssociatedTunnelsResult:
    """
    A collection of values returned by getVirtualCircuitAssociatedTunnels.
    """
    def __init__(__self__, filters=None, id=None, virtual_circuit_associated_tunnel_details=None, virtual_circuit_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if virtual_circuit_associated_tunnel_details and not isinstance(virtual_circuit_associated_tunnel_details, list):
            raise TypeError("Expected argument 'virtual_circuit_associated_tunnel_details' to be a list")
        pulumi.set(__self__, "virtual_circuit_associated_tunnel_details", virtual_circuit_associated_tunnel_details)
        if virtual_circuit_id and not isinstance(virtual_circuit_id, str):
            raise TypeError("Expected argument 'virtual_circuit_id' to be a str")
        pulumi.set(__self__, "virtual_circuit_id", virtual_circuit_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualCircuitAssociatedTunnelsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="virtualCircuitAssociatedTunnelDetails")
    def virtual_circuit_associated_tunnel_details(self) -> Sequence['outputs.GetVirtualCircuitAssociatedTunnelsVirtualCircuitAssociatedTunnelDetailResult']:
        """
        The list of virtual_circuit_associated_tunnel_details.
        """
        return pulumi.get(self, "virtual_circuit_associated_tunnel_details")

    @property
    @pulumi.getter(name="virtualCircuitId")
    def virtual_circuit_id(self) -> str:
        return pulumi.get(self, "virtual_circuit_id")


class AwaitableGetVirtualCircuitAssociatedTunnelsResult(GetVirtualCircuitAssociatedTunnelsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualCircuitAssociatedTunnelsResult(
            filters=self.filters,
            id=self.id,
            virtual_circuit_associated_tunnel_details=self.virtual_circuit_associated_tunnel_details,
            virtual_circuit_id=self.virtual_circuit_id)


def get_virtual_circuit_associated_tunnels(filters: Optional[Sequence[pulumi.InputType['GetVirtualCircuitAssociatedTunnelsFilterArgs']]] = None,
                                           virtual_circuit_id: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualCircuitAssociatedTunnelsResult:
    """
    This data source provides the list of Virtual Circuit Associated Tunnels in Oracle Cloud Infrastructure Core service.

    Gets the specified virtual circuit's associatedTunnelsInfo.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_circuit_associated_tunnels = oci.Core.get_virtual_circuit_associated_tunnels(virtual_circuit_id=test_virtual_circuit["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str virtual_circuit_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual circuit.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['virtualCircuitId'] = virtual_circuit_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVirtualCircuitAssociatedTunnels:getVirtualCircuitAssociatedTunnels', __args__, opts=opts, typ=GetVirtualCircuitAssociatedTunnelsResult).value

    return AwaitableGetVirtualCircuitAssociatedTunnelsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        virtual_circuit_associated_tunnel_details=pulumi.get(__ret__, 'virtual_circuit_associated_tunnel_details'),
        virtual_circuit_id=pulumi.get(__ret__, 'virtual_circuit_id'))


@_utilities.lift_output_func(get_virtual_circuit_associated_tunnels)
def get_virtual_circuit_associated_tunnels_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVirtualCircuitAssociatedTunnelsFilterArgs']]]]] = None,
                                                  virtual_circuit_id: Optional[pulumi.Input[str]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVirtualCircuitAssociatedTunnelsResult]:
    """
    This data source provides the list of Virtual Circuit Associated Tunnels in Oracle Cloud Infrastructure Core service.

    Gets the specified virtual circuit's associatedTunnelsInfo.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_circuit_associated_tunnels = oci.Core.get_virtual_circuit_associated_tunnels(virtual_circuit_id=test_virtual_circuit["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str virtual_circuit_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual circuit.
    """
    ...
