# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualCircuitPublicPrefixesResult',
    'AwaitableGetVirtualCircuitPublicPrefixesResult',
    'get_virtual_circuit_public_prefixes',
    'get_virtual_circuit_public_prefixes_output',
]

@pulumi.output_type
class GetVirtualCircuitPublicPrefixesResult:
    """
    A collection of values returned by getVirtualCircuitPublicPrefixes.
    """
    def __init__(__self__, filters=None, id=None, verification_state=None, virtual_circuit_id=None, virtual_circuit_public_prefixes=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if verification_state and not isinstance(verification_state, str):
            raise TypeError("Expected argument 'verification_state' to be a str")
        pulumi.set(__self__, "verification_state", verification_state)
        if virtual_circuit_id and not isinstance(virtual_circuit_id, str):
            raise TypeError("Expected argument 'virtual_circuit_id' to be a str")
        pulumi.set(__self__, "virtual_circuit_id", virtual_circuit_id)
        if virtual_circuit_public_prefixes and not isinstance(virtual_circuit_public_prefixes, list):
            raise TypeError("Expected argument 'virtual_circuit_public_prefixes' to be a list")
        pulumi.set(__self__, "virtual_circuit_public_prefixes", virtual_circuit_public_prefixes)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualCircuitPublicPrefixesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="verificationState")
    def verification_state(self) -> Optional[str]:
        """
        Oracle must verify that the customer owns the public IP prefix before traffic for that prefix can flow across the virtual circuit. Verification can take a few business days. `IN_PROGRESS` means Oracle is verifying the prefix. `COMPLETED` means verification succeeded. `FAILED` means verification failed and traffic for this prefix will not flow across the connection.
        """
        return pulumi.get(self, "verification_state")

    @property
    @pulumi.getter(name="virtualCircuitId")
    def virtual_circuit_id(self) -> str:
        return pulumi.get(self, "virtual_circuit_id")

    @property
    @pulumi.getter(name="virtualCircuitPublicPrefixes")
    def virtual_circuit_public_prefixes(self) -> Sequence['outputs.GetVirtualCircuitPublicPrefixesVirtualCircuitPublicPrefixResult']:
        """
        The list of virtual_circuit_public_prefixes.
        """
        return pulumi.get(self, "virtual_circuit_public_prefixes")


class AwaitableGetVirtualCircuitPublicPrefixesResult(GetVirtualCircuitPublicPrefixesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualCircuitPublicPrefixesResult(
            filters=self.filters,
            id=self.id,
            verification_state=self.verification_state,
            virtual_circuit_id=self.virtual_circuit_id,
            virtual_circuit_public_prefixes=self.virtual_circuit_public_prefixes)


def get_virtual_circuit_public_prefixes(filters: Optional[Sequence[pulumi.InputType['GetVirtualCircuitPublicPrefixesFilterArgs']]] = None,
                                        verification_state: Optional[str] = None,
                                        virtual_circuit_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualCircuitPublicPrefixesResult:
    """
    This data source provides the list of Virtual Circuit Public Prefixes in Oracle Cloud Infrastructure Core service.

    Lists the public IP prefixes and their details for the specified
    public virtual circuit.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_circuit_public_prefixes = oci.Core.get_virtual_circuit_public_prefixes(virtual_circuit_id=test_virtual_circuit["id"],
        verification_state=virtual_circuit_public_prefix_verification_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str verification_state: A filter to only return resources that match the given verification state.
           
           The state value is case-insensitive.
    :param str virtual_circuit_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual circuit.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['verificationState'] = verification_state
    __args__['virtualCircuitId'] = virtual_circuit_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVirtualCircuitPublicPrefixes:getVirtualCircuitPublicPrefixes', __args__, opts=opts, typ=GetVirtualCircuitPublicPrefixesResult).value

    return AwaitableGetVirtualCircuitPublicPrefixesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        verification_state=pulumi.get(__ret__, 'verification_state'),
        virtual_circuit_id=pulumi.get(__ret__, 'virtual_circuit_id'),
        virtual_circuit_public_prefixes=pulumi.get(__ret__, 'virtual_circuit_public_prefixes'))


@_utilities.lift_output_func(get_virtual_circuit_public_prefixes)
def get_virtual_circuit_public_prefixes_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVirtualCircuitPublicPrefixesFilterArgs']]]]] = None,
                                               verification_state: Optional[pulumi.Input[Optional[str]]] = None,
                                               virtual_circuit_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVirtualCircuitPublicPrefixesResult]:
    """
    This data source provides the list of Virtual Circuit Public Prefixes in Oracle Cloud Infrastructure Core service.

    Lists the public IP prefixes and their details for the specified
    public virtual circuit.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_circuit_public_prefixes = oci.Core.get_virtual_circuit_public_prefixes(virtual_circuit_id=test_virtual_circuit["id"],
        verification_state=virtual_circuit_public_prefix_verification_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str verification_state: A filter to only return resources that match the given verification state.
           
           The state value is case-insensitive.
    :param str virtual_circuit_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual circuit.
    """
    ...
