# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AutonomousDatabaseSaasAdminUserArgs', 'AutonomousDatabaseSaasAdminUser']

@pulumi.input_type
class AutonomousDatabaseSaasAdminUserArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[str],
                 access_type: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 time_saas_admin_user_enabled: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseSaasAdminUser resource.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] access_type: The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        :param pulumi.Input[int] duration: How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        :param pulumi.Input[str] password: A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        :param pulumi.Input[str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        :param pulumi.Input[int] secret_version_number: The version of the vault secret. If no version is specified, the latest version will be used.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version_number is not None:
            pulumi.set(__self__, "secret_version_number", secret_version_number)
        if time_saas_admin_user_enabled is not None:
            pulumi.set(__self__, "time_saas_admin_user_enabled", time_saas_admin_user_enabled)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "autonomous_database_id", value)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[str]]:
        """
        The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the vault secret. If no version is specified, the latest version will be used.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "secret_version_number")

    @secret_version_number.setter
    def secret_version_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secret_version_number", value)

    @property
    @pulumi.getter(name="timeSaasAdminUserEnabled")
    def time_saas_admin_user_enabled(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_saas_admin_user_enabled")

    @time_saas_admin_user_enabled.setter
    def time_saas_admin_user_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_saas_admin_user_enabled", value)


@pulumi.input_type
class _AutonomousDatabaseSaasAdminUserState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 time_saas_admin_user_enabled: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseSaasAdminUser resources.
        :param pulumi.Input[str] access_type: The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[int] duration: How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        :param pulumi.Input[str] password: A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        :param pulumi.Input[str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        :param pulumi.Input[int] secret_version_number: The version of the vault secret. If no version is specified, the latest version will be used.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version_number is not None:
            pulumi.set(__self__, "secret_version_number", secret_version_number)
        if time_saas_admin_user_enabled is not None:
            pulumi.set(__self__, "time_saas_admin_user_enabled", time_saas_admin_user_enabled)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[str]]:
        """
        The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the vault secret. If no version is specified, the latest version will be used.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "secret_version_number")

    @secret_version_number.setter
    def secret_version_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secret_version_number", value)

    @property
    @pulumi.getter(name="timeSaasAdminUserEnabled")
    def time_saas_admin_user_enabled(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_saas_admin_user_enabled")

    @time_saas_admin_user_enabled.setter
    def time_saas_admin_user_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_saas_admin_user_enabled", value)


class AutonomousDatabaseSaasAdminUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 time_saas_admin_user_enabled: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource creates and enables the Autonomous Database administrative user account in Oracle Cloud Infrastructure Database service.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_saas_admin_user = oci.database.AutonomousDatabaseSaasAdminUser("test_autonomous_database_saas_admin_user",
            autonomous_database_id=test_autonomous_database["id"],
            password=autonomous_database_saas_admin_user_password,
            access_type=autonomous_database_saas_admin_user_access_type,
            duration=autonomous_database_saas_admin_user_duration)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_type: The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[int] duration: How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        :param pulumi.Input[str] password: A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        :param pulumi.Input[str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        :param pulumi.Input[int] secret_version_number: The version of the vault secret. If no version is specified, the latest version will be used.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseSaasAdminUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource creates and enables the Autonomous Database administrative user account in Oracle Cloud Infrastructure Database service.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_saas_admin_user = oci.database.AutonomousDatabaseSaasAdminUser("test_autonomous_database_saas_admin_user",
            autonomous_database_id=test_autonomous_database["id"],
            password=autonomous_database_saas_admin_user_password,
            access_type=autonomous_database_saas_admin_user_access_type,
            duration=autonomous_database_saas_admin_user_duration)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseSaasAdminUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseSaasAdminUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 time_saas_admin_user_enabled: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseSaasAdminUserArgs.__new__(AutonomousDatabaseSaasAdminUserArgs)

            __props__.__dict__["access_type"] = access_type
            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["duration"] = duration
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["secret_version_number"] = secret_version_number
            __props__.__dict__["time_saas_admin_user_enabled"] = time_saas_admin_user_enabled
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabaseSaasAdminUser, __self__).__init__(
            'oci:Database/autonomousDatabaseSaasAdminUser:AutonomousDatabaseSaasAdminUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[str]] = None,
            autonomous_database_id: Optional[pulumi.Input[str]] = None,
            duration: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            secret_id: Optional[pulumi.Input[str]] = None,
            secret_version_number: Optional[pulumi.Input[int]] = None,
            time_saas_admin_user_enabled: Optional[pulumi.Input[str]] = None) -> 'AutonomousDatabaseSaasAdminUser':
        """
        Get an existing AutonomousDatabaseSaasAdminUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_type: The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[int] duration: How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        :param pulumi.Input[str] password: A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        :param pulumi.Input[str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        :param pulumi.Input[int] secret_version_number: The version of the vault secret. If no version is specified, the latest version will be used.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseSaasAdminUserState.__new__(_AutonomousDatabaseSaasAdminUserState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["duration"] = duration
        __props__.__dict__["password"] = password
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["secret_version_number"] = secret_version_number
        __props__.__dict__["time_saas_admin_user_enabled"] = time_saas_admin_user_enabled
        return AutonomousDatabaseSaasAdminUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[Optional[str]]:
        """
        The access type for the SaaS administrative user. If no access type is specified, the READ_ONLY access type is used.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[int]]:
        """
        How long, in hours, the SaaS administrative user will stay enabled. If no duration is specified, the default value 1 will be used.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        A strong password for SaaS administrative user. The password must be a minimum of nine (9) characters and contain a minimum of two (2) uppercase, two (2) lowercase, two (2) numbers, and two (2) special characters from _ (underscore), \\# (hashtag), or - (dash). The password is mandatory if "secret_id" is not present.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[Optional[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). The secret is mandatory if "password" is not present.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> pulumi.Output[Optional[int]]:
        """
        The version of the vault secret. If no version is specified, the latest version will be used.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "secret_version_number")

    @property
    @pulumi.getter(name="timeSaasAdminUserEnabled")
    def time_saas_admin_user_enabled(self) -> pulumi.Output[str]:
        return pulumi.get(self, "time_saas_admin_user_enabled")

