# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AutonomousDatabaseSoftwareImageArgs', 'AutonomousDatabaseSoftwareImage']

@pulumi.input_type
class AutonomousDatabaseSoftwareImageArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 image_shape_family: pulumi.Input[str],
                 source_cdb_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseSoftwareImage resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        :param pulumi.Input[str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[str] source_cdb_id: The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "image_shape_family", image_shape_family)
        pulumi.set(__self__, "source_cdb_id", source_cdb_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> pulumi.Input[str]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @image_shape_family.setter
    def image_shape_family(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_shape_family", value)

    @property
    @pulumi.getter(name="sourceCdbId")
    def source_cdb_id(self) -> pulumi.Input[str]:
        """
        The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_cdb_id")

    @source_cdb_id.setter
    def source_cdb_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_cdb_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AutonomousDatabaseSoftwareImageState:
    def __init__(__self__, *,
                 autonomous_dsi_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_shape_family: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 release_update: Optional[pulumi.Input[str]] = None,
                 source_cdb_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseSoftwareImage resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autonomous_dsi_one_off_patches: One-off patches included in the Autonomous Database Software Image
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] database_version: The database version with which the Autonomous Database Software Image is to be built.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[str] release_update: The Release Updates.
        :param pulumi.Input[str] source_cdb_id: The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the Autonomous Database Software Image.
        :param pulumi.Input[str] time_created: The date and time the Autonomous Database Software Image was created.
        """
        if autonomous_dsi_one_off_patches is not None:
            pulumi.set(__self__, "autonomous_dsi_one_off_patches", autonomous_dsi_one_off_patches)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_shape_family is not None:
            pulumi.set(__self__, "image_shape_family", image_shape_family)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if release_update is not None:
            pulumi.set(__self__, "release_update", release_update)
        if source_cdb_id is not None:
            pulumi.set(__self__, "source_cdb_id", source_cdb_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="autonomousDsiOneOffPatches")
    def autonomous_dsi_one_off_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One-off patches included in the Autonomous Database Software Image
        """
        return pulumi.get(self, "autonomous_dsi_one_off_patches")

    @autonomous_dsi_one_off_patches.setter
    def autonomous_dsi_one_off_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "autonomous_dsi_one_off_patches", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database version with which the Autonomous Database Software Image is to be built.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> Optional[pulumi.Input[str]]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @image_shape_family.setter
    def image_shape_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_shape_family", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> Optional[pulumi.Input[str]]:
        """
        The Release Updates.
        """
        return pulumi.get(self, "release_update")

    @release_update.setter
    def release_update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_update", value)

    @property
    @pulumi.getter(name="sourceCdbId")
    def source_cdb_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_cdb_id")

    @source_cdb_id.setter
    def source_cdb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cdb_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Autonomous Database Software Image.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Autonomous Database Software Image was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class AutonomousDatabaseSoftwareImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_shape_family: Optional[pulumi.Input[str]] = None,
                 source_cdb_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Database Software Image resource in Oracle Cloud Infrastructure Database service.

        create Autonomous Database Software Image in the specified compartment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_software_image = oci.database.AutonomousDatabaseSoftwareImage("test_autonomous_database_software_image",
            compartment_id=compartment_id,
            display_name=autonomous_database_software_image_display_name,
            image_shape_family=autonomous_database_software_image_image_shape_family,
            source_cdb_id=test_source_cdb["id"],
            defined_tags=autonomous_database_software_image_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        AutonomousDatabaseSoftwareImages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousDatabaseSoftwareImage:AutonomousDatabaseSoftwareImage test_autonomous_database_software_image "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[str] source_cdb_id: The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseSoftwareImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Database Software Image resource in Oracle Cloud Infrastructure Database service.

        create Autonomous Database Software Image in the specified compartment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_software_image = oci.database.AutonomousDatabaseSoftwareImage("test_autonomous_database_software_image",
            compartment_id=compartment_id,
            display_name=autonomous_database_software_image_display_name,
            image_shape_family=autonomous_database_software_image_image_shape_family,
            source_cdb_id=test_source_cdb["id"],
            defined_tags=autonomous_database_software_image_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        AutonomousDatabaseSoftwareImages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousDatabaseSoftwareImage:AutonomousDatabaseSoftwareImage test_autonomous_database_software_image "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseSoftwareImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseSoftwareImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_shape_family: Optional[pulumi.Input[str]] = None,
                 source_cdb_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseSoftwareImageArgs.__new__(AutonomousDatabaseSoftwareImageArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if image_shape_family is None and not opts.urn:
                raise TypeError("Missing required property 'image_shape_family'")
            __props__.__dict__["image_shape_family"] = image_shape_family
            if source_cdb_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_cdb_id'")
            __props__.__dict__["source_cdb_id"] = source_cdb_id
            __props__.__dict__["autonomous_dsi_one_off_patches"] = None
            __props__.__dict__["database_version"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["release_update"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(AutonomousDatabaseSoftwareImage, __self__).__init__(
            'oci:Database/autonomousDatabaseSoftwareImage:AutonomousDatabaseSoftwareImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_dsi_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            image_shape_family: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            release_update: Optional[pulumi.Input[str]] = None,
            source_cdb_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'AutonomousDatabaseSoftwareImage':
        """
        Get an existing AutonomousDatabaseSoftwareImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autonomous_dsi_one_off_patches: One-off patches included in the Autonomous Database Software Image
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] database_version: The database version with which the Autonomous Database Software Image is to be built.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[str] release_update: The Release Updates.
        :param pulumi.Input[str] source_cdb_id: The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the Autonomous Database Software Image.
        :param pulumi.Input[str] time_created: The date and time the Autonomous Database Software Image was created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseSoftwareImageState.__new__(_AutonomousDatabaseSoftwareImageState)

        __props__.__dict__["autonomous_dsi_one_off_patches"] = autonomous_dsi_one_off_patches
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image_shape_family"] = image_shape_family
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["release_update"] = release_update
        __props__.__dict__["source_cdb_id"] = source_cdb_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return AutonomousDatabaseSoftwareImage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autonomousDsiOneOffPatches")
    def autonomous_dsi_one_off_patches(self) -> pulumi.Output[Sequence[str]]:
        """
        One-off patches included in the Autonomous Database Software Image
        """
        return pulumi.get(self, "autonomous_dsi_one_off_patches")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The database version with which the Autonomous Database Software Image is to be built.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> pulumi.Output[str]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> pulumi.Output[str]:
        """
        The Release Updates.
        """
        return pulumi.get(self, "release_update")

    @property
    @pulumi.getter(name="sourceCdbId")
    def source_cdb_id(self) -> pulumi.Output[str]:
        """
        The source Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) from which to create Autonomous Database Software Image.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_cdb_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Autonomous Database Software Image.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Autonomous Database Software Image was created.
        """
        return pulumi.get(self, "time_created")

