# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseSoftwareImagesResult',
    'AwaitableGetAutonomousDatabaseSoftwareImagesResult',
    'get_autonomous_database_software_images',
    'get_autonomous_database_software_images_output',
]

@pulumi.output_type
class GetAutonomousDatabaseSoftwareImagesResult:
    """
    A collection of values returned by getAutonomousDatabaseSoftwareImages.
    """
    def __init__(__self__, autonomous_database_software_image_collections=None, compartment_id=None, display_name=None, filters=None, id=None, image_shape_family=None, state=None):
        if autonomous_database_software_image_collections and not isinstance(autonomous_database_software_image_collections, list):
            raise TypeError("Expected argument 'autonomous_database_software_image_collections' to be a list")
        pulumi.set(__self__, "autonomous_database_software_image_collections", autonomous_database_software_image_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_shape_family and not isinstance(image_shape_family, str):
            raise TypeError("Expected argument 'image_shape_family' to be a str")
        pulumi.set(__self__, "image_shape_family", image_shape_family)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autonomousDatabaseSoftwareImageCollections")
    def autonomous_database_software_image_collections(self) -> Sequence['outputs.GetAutonomousDatabaseSoftwareImagesAutonomousDatabaseSoftwareImageCollectionResult']:
        """
        The list of autonomous_database_software_image_collection.
        """
        return pulumi.get(self, "autonomous_database_software_image_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseSoftwareImagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> str:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Autonomous Database Software Image.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousDatabaseSoftwareImagesResult(GetAutonomousDatabaseSoftwareImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseSoftwareImagesResult(
            autonomous_database_software_image_collections=self.autonomous_database_software_image_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            image_shape_family=self.image_shape_family,
            state=self.state)


def get_autonomous_database_software_images(compartment_id: Optional[str] = None,
                                            display_name: Optional[str] = None,
                                            filters: Optional[Sequence[pulumi.InputType['GetAutonomousDatabaseSoftwareImagesFilterArgs']]] = None,
                                            image_shape_family: Optional[str] = None,
                                            state: Optional[str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseSoftwareImagesResult:
    """
    This data source provides the list of Autonomous Database Software Images in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Database Software Images in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_software_images = oci.Database.get_autonomous_database_software_images(compartment_id=compartment_id,
        image_shape_family=autonomous_database_software_image_image_shape_family,
        display_name=autonomous_database_software_image_display_name,
        state=autonomous_database_software_image_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str image_shape_family: A filter to return only resources that match the given image shape family exactly.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageShapeFamily'] = image_shape_family
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseSoftwareImages:getAutonomousDatabaseSoftwareImages', __args__, opts=opts, typ=GetAutonomousDatabaseSoftwareImagesResult).value

    return AwaitableGetAutonomousDatabaseSoftwareImagesResult(
        autonomous_database_software_image_collections=pulumi.get(__ret__, 'autonomous_database_software_image_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_shape_family=pulumi.get(__ret__, 'image_shape_family'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_autonomous_database_software_images)
def get_autonomous_database_software_images_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAutonomousDatabaseSoftwareImagesFilterArgs']]]]] = None,
                                                   image_shape_family: Optional[pulumi.Input[str]] = None,
                                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabaseSoftwareImagesResult]:
    """
    This data source provides the list of Autonomous Database Software Images in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Database Software Images in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_software_images = oci.Database.get_autonomous_database_software_images(compartment_id=compartment_id,
        image_shape_family=autonomous_database_software_image_image_shape_family,
        display_name=autonomous_database_software_image_display_name,
        state=autonomous_database_software_image_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str image_shape_family: A filter to return only resources that match the given image shape family exactly.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
