# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbNodeConsoleConnectionsResult',
    'AwaitableGetDbNodeConsoleConnectionsResult',
    'get_db_node_console_connections',
    'get_db_node_console_connections_output',
]

@pulumi.output_type
class GetDbNodeConsoleConnectionsResult:
    """
    A collection of values returned by getDbNodeConsoleConnections.
    """
    def __init__(__self__, console_connections=None, db_node_id=None, filters=None, id=None):
        if console_connections and not isinstance(console_connections, list):
            raise TypeError("Expected argument 'console_connections' to be a list")
        pulumi.set(__self__, "console_connections", console_connections)
        if db_node_id and not isinstance(db_node_id, str):
            raise TypeError("Expected argument 'db_node_id' to be a str")
        pulumi.set(__self__, "db_node_id", db_node_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="consoleConnections")
    def console_connections(self) -> Sequence['outputs.GetDbNodeConsoleConnectionsConsoleConnectionResult']:
        """
        The list of console_connections.
        """
        return pulumi.get(self, "console_connections")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> str:
        """
        The OCID of the database node.
        """
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbNodeConsoleConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDbNodeConsoleConnectionsResult(GetDbNodeConsoleConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeConsoleConnectionsResult(
            console_connections=self.console_connections,
            db_node_id=self.db_node_id,
            filters=self.filters,
            id=self.id)


def get_db_node_console_connections(db_node_id: Optional[str] = None,
                                    filters: Optional[Sequence[pulumi.InputType['GetDbNodeConsoleConnectionsFilterArgs']]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeConsoleConnectionsResult:
    """
    This data source provides the list of Db Node Console Connections in Oracle Cloud Infrastructure Database service.

    Lists the console connections for the specified database node.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_connections = oci.Database.get_db_node_console_connections(db_node_id=test_db_node["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbNodeId'] = db_node_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeConsoleConnections:getDbNodeConsoleConnections', __args__, opts=opts, typ=GetDbNodeConsoleConnectionsResult).value

    return AwaitableGetDbNodeConsoleConnectionsResult(
        console_connections=pulumi.get(__ret__, 'console_connections'),
        db_node_id=pulumi.get(__ret__, 'db_node_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_db_node_console_connections)
def get_db_node_console_connections_output(db_node_id: Optional[pulumi.Input[str]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDbNodeConsoleConnectionsFilterArgs']]]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbNodeConsoleConnectionsResult]:
    """
    This data source provides the list of Db Node Console Connections in Oracle Cloud Infrastructure Database service.

    Lists the console connections for the specified database node.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_connections = oci.Database.get_db_node_console_connections(db_node_id=test_db_node["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
