# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbNodeConsoleHistoriesResult',
    'AwaitableGetDbNodeConsoleHistoriesResult',
    'get_db_node_console_histories',
    'get_db_node_console_histories_output',
]

@pulumi.output_type
class GetDbNodeConsoleHistoriesResult:
    """
    A collection of values returned by getDbNodeConsoleHistories.
    """
    def __init__(__self__, console_history_collections=None, db_node_id=None, display_name=None, filters=None, id=None, state=None):
        if console_history_collections and not isinstance(console_history_collections, list):
            raise TypeError("Expected argument 'console_history_collections' to be a list")
        pulumi.set(__self__, "console_history_collections", console_history_collections)
        if db_node_id and not isinstance(db_node_id, str):
            raise TypeError("Expected argument 'db_node_id' to be a str")
        pulumi.set(__self__, "db_node_id", db_node_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="consoleHistoryCollections")
    def console_history_collections(self) -> Sequence['outputs.GetDbNodeConsoleHistoriesConsoleHistoryCollectionResult']:
        """
        The list of console_history_collection.
        """
        return pulumi.get(self, "console_history_collections")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> str:
        """
        The OCID of the database node.
        """
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the console history. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbNodeConsoleHistoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the console history.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbNodeConsoleHistoriesResult(GetDbNodeConsoleHistoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeConsoleHistoriesResult(
            console_history_collections=self.console_history_collections,
            db_node_id=self.db_node_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_db_node_console_histories(db_node_id: Optional[str] = None,
                                  display_name: Optional[str] = None,
                                  filters: Optional[Sequence[pulumi.InputType['GetDbNodeConsoleHistoriesFilterArgs']]] = None,
                                  state: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeConsoleHistoriesResult:
    """
    This data source provides the list of Db Node Console Histories in Oracle Cloud Infrastructure Database service.

    Lists the console histories for the specified database node.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_histories = oci.Database.get_db_node_console_histories(db_node_id=test_db_node["id"],
        display_name=db_node_console_history_display_name,
        state=db_node_console_history_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['dbNodeId'] = db_node_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeConsoleHistories:getDbNodeConsoleHistories', __args__, opts=opts, typ=GetDbNodeConsoleHistoriesResult).value

    return AwaitableGetDbNodeConsoleHistoriesResult(
        console_history_collections=pulumi.get(__ret__, 'console_history_collections'),
        db_node_id=pulumi.get(__ret__, 'db_node_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_db_node_console_histories)
def get_db_node_console_histories_output(db_node_id: Optional[pulumi.Input[str]] = None,
                                         display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDbNodeConsoleHistoriesFilterArgs']]]]] = None,
                                         state: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbNodeConsoleHistoriesResult]:
    """
    This data source provides the list of Db Node Console Histories in Oracle Cloud Infrastructure Database service.

    Lists the console histories for the specified database node.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_histories = oci.Database.get_db_node_console_histories(db_node_id=test_db_node["id"],
        display_name=db_node_console_history_display_name,
        state=db_node_console_history_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
