# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFlexComponentsResult',
    'AwaitableGetFlexComponentsResult',
    'get_flex_components',
    'get_flex_components_output',
]

@pulumi.output_type
class GetFlexComponentsResult:
    """
    A collection of values returned by getFlexComponents.
    """
    def __init__(__self__, compartment_id=None, filters=None, flex_component_collections=None, id=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if flex_component_collections and not isinstance(flex_component_collections, list):
            raise TypeError("Expected argument 'flex_component_collections' to be a list")
        pulumi.set(__self__, "flex_component_collections", flex_component_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFlexComponentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="flexComponentCollections")
    def flex_component_collections(self) -> Sequence['outputs.GetFlexComponentsFlexComponentCollectionResult']:
        """
        The list of flex_component_collection.
        """
        return pulumi.get(self, "flex_component_collections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Flex Component used for the DB system.
        """
        return pulumi.get(self, "name")


class AwaitableGetFlexComponentsResult(GetFlexComponentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlexComponentsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            flex_component_collections=self.flex_component_collections,
            id=self.id,
            name=self.name)


def get_flex_components(compartment_id: Optional[str] = None,
                        filters: Optional[Sequence[pulumi.InputType['GetFlexComponentsFilterArgs']]] = None,
                        name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlexComponentsResult:
    """
    This data source provides the list of Flex Components in Oracle Cloud Infrastructure Database service.

    Gets a list of the flex components that can be used to launch a new DB system. The flex component determines resources to allocate to the DB system - Database Servers and Storage Servers.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_flex_components = oci.Database.get_flex_components(compartment_id=compartment_id,
        name=flex_component_name)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getFlexComponents:getFlexComponents', __args__, opts=opts, typ=GetFlexComponentsResult).value

    return AwaitableGetFlexComponentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        flex_component_collections=pulumi.get(__ret__, 'flex_component_collections'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_flex_components)
def get_flex_components_output(compartment_id: Optional[pulumi.Input[str]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFlexComponentsFilterArgs']]]]] = None,
                               name: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlexComponentsResult]:
    """
    This data source provides the list of Flex Components in Oracle Cloud Infrastructure Database service.

    Gets a list of the flex components that can be used to launch a new DB system. The flex component determines resources to allocate to the DB system - Database Servers and Storage Servers.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_flex_components = oci.Database.get_flex_components(compartment_id=compartment_id,
        name=flex_component_name)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    """
    ...
