# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalExadataStorageServerTopSqlCpuActivityResult',
    'AwaitableGetExternalExadataStorageServerTopSqlCpuActivityResult',
    'get_external_exadata_storage_server_top_sql_cpu_activity',
    'get_external_exadata_storage_server_top_sql_cpu_activity_output',
]

@pulumi.output_type
class GetExternalExadataStorageServerTopSqlCpuActivityResult:
    """
    A collection of values returned by getExternalExadataStorageServerTopSqlCpuActivity.
    """
    def __init__(__self__, activities=None, external_exadata_storage_server_id=None, id=None):
        if activities and not isinstance(activities, list):
            raise TypeError("Expected argument 'activities' to be a list")
        pulumi.set(__self__, "activities", activities)
        if external_exadata_storage_server_id and not isinstance(external_exadata_storage_server_id, str):
            raise TypeError("Expected argument 'external_exadata_storage_server_id' to be a str")
        pulumi.set(__self__, "external_exadata_storage_server_id", external_exadata_storage_server_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def activities(self) -> Sequence['outputs.GetExternalExadataStorageServerTopSqlCpuActivityActivityResult']:
        """
        A list of sql CPU activity.
        """
        return pulumi.get(self, "activities")

    @property
    @pulumi.getter(name="externalExadataStorageServerId")
    def external_exadata_storage_server_id(self) -> str:
        return pulumi.get(self, "external_exadata_storage_server_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetExternalExadataStorageServerTopSqlCpuActivityResult(GetExternalExadataStorageServerTopSqlCpuActivityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataStorageServerTopSqlCpuActivityResult(
            activities=self.activities,
            external_exadata_storage_server_id=self.external_exadata_storage_server_id,
            id=self.id)


def get_external_exadata_storage_server_top_sql_cpu_activity(external_exadata_storage_server_id: Optional[str] = None,
                                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataStorageServerTopSqlCpuActivityResult:
    """
    This data source provides details about a specific External Exadata Storage Server Top Sql Cpu Activity resource in Oracle Cloud Infrastructure Database Management service.

    Gets the SQL IDs with the top CPU activity from the Exadata storage server.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_server_top_sql_cpu_activity = oci.DatabaseManagement.get_external_exadata_storage_server_top_sql_cpu_activity(external_exadata_storage_server_id=test_external_exadata_storage_server["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageServerId'] = external_exadata_storage_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataStorageServerTopSqlCpuActivity:getExternalExadataStorageServerTopSqlCpuActivity', __args__, opts=opts, typ=GetExternalExadataStorageServerTopSqlCpuActivityResult).value

    return AwaitableGetExternalExadataStorageServerTopSqlCpuActivityResult(
        activities=pulumi.get(__ret__, 'activities'),
        external_exadata_storage_server_id=pulumi.get(__ret__, 'external_exadata_storage_server_id'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_external_exadata_storage_server_top_sql_cpu_activity)
def get_external_exadata_storage_server_top_sql_cpu_activity_output(external_exadata_storage_server_id: Optional[pulumi.Input[str]] = None,
                                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalExadataStorageServerTopSqlCpuActivityResult]:
    """
    This data source provides details about a specific External Exadata Storage Server Top Sql Cpu Activity resource in Oracle Cloud Infrastructure Database Management service.

    Gets the SQL IDs with the top CPU activity from the Exadata storage server.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_server_top_sql_cpu_activity = oci.DatabaseManagement.get_external_exadata_storage_server_top_sql_cpu_activity(external_exadata_storage_server_id=test_external_exadata_storage_server["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
    """
    ...
