# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalListenerServicesResult',
    'AwaitableGetExternalListenerServicesResult',
    'get_external_listener_services',
    'get_external_listener_services_output',
]

@pulumi.output_type
class GetExternalListenerServicesResult:
    """
    A collection of values returned by getExternalListenerServices.
    """
    def __init__(__self__, external_listener_id=None, external_listener_service_collections=None, filters=None, id=None, managed_database_id=None, opc_named_credential_id=None):
        if external_listener_id and not isinstance(external_listener_id, str):
            raise TypeError("Expected argument 'external_listener_id' to be a str")
        pulumi.set(__self__, "external_listener_id", external_listener_id)
        if external_listener_service_collections and not isinstance(external_listener_service_collections, list):
            raise TypeError("Expected argument 'external_listener_service_collections' to be a list")
        pulumi.set(__self__, "external_listener_service_collections", external_listener_service_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)

    @property
    @pulumi.getter(name="externalListenerId")
    def external_listener_id(self) -> str:
        return pulumi.get(self, "external_listener_id")

    @property
    @pulumi.getter(name="externalListenerServiceCollections")
    def external_listener_service_collections(self) -> Sequence['outputs.GetExternalListenerServicesExternalListenerServiceCollectionResult']:
        """
        The list of external_listener_service_collection.
        """
        return pulumi.get(self, "external_listener_service_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalListenerServicesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")


class AwaitableGetExternalListenerServicesResult(GetExternalListenerServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalListenerServicesResult(
            external_listener_id=self.external_listener_id,
            external_listener_service_collections=self.external_listener_service_collections,
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            opc_named_credential_id=self.opc_named_credential_id)


def get_external_listener_services(external_listener_id: Optional[str] = None,
                                   filters: Optional[Sequence[pulumi.InputType['GetExternalListenerServicesFilterArgs']]] = None,
                                   managed_database_id: Optional[str] = None,
                                   opc_named_credential_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalListenerServicesResult:
    """
    This data source provides the list of External Listener Services in Oracle Cloud Infrastructure Database Management service.

    Lists the database services registered with the specified external listener
    for the specified Managed Database.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_listener_services = oci.DatabaseManagement.get_external_listener_services(external_listener_id=test_external_listener["id"],
        managed_database_id=test_managed_database["id"],
        opc_named_credential_id=external_listener_service_opc_named_credential_id)
    ```
    <!--End PulumiCodeChooser -->


    :param str external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['externalListenerId'] = external_listener_id
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalListenerServices:getExternalListenerServices', __args__, opts=opts, typ=GetExternalListenerServicesResult).value

    return AwaitableGetExternalListenerServicesResult(
        external_listener_id=pulumi.get(__ret__, 'external_listener_id'),
        external_listener_service_collections=pulumi.get(__ret__, 'external_listener_service_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'))


@_utilities.lift_output_func(get_external_listener_services)
def get_external_listener_services_output(external_listener_id: Optional[pulumi.Input[str]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetExternalListenerServicesFilterArgs']]]]] = None,
                                          managed_database_id: Optional[pulumi.Input[str]] = None,
                                          opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalListenerServicesResult]:
    """
    This data source provides the list of External Listener Services in Oracle Cloud Infrastructure Database Management service.

    Lists the database services registered with the specified external listener
    for the specified Managed Database.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_listener_services = oci.DatabaseManagement.get_external_listener_services(external_listener_id=test_external_listener["id"],
        managed_database_id=test_managed_database["id"],
        opc_named_credential_id=external_listener_service_opc_named_credential_id)
    ```
    <!--End PulumiCodeChooser -->


    :param str external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    """
    ...
