# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseGroupsResult',
    'AwaitableGetManagedDatabaseGroupsResult',
    'get_managed_database_groups',
    'get_managed_database_groups_output',
]

@pulumi.output_type
class GetManagedDatabaseGroupsResult:
    """
    A collection of values returned by getManagedDatabaseGroups.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, managed_database_group_collections=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_group_collections and not isinstance(managed_database_group_collections, list):
            raise TypeError("Expected argument 'managed_database_group_collections' to be a list")
        pulumi.set(__self__, "managed_database_group_collections", managed_database_group_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseGroupCollections")
    def managed_database_group_collections(self) -> Sequence['outputs.GetManagedDatabaseGroupsManagedDatabaseGroupCollectionResult']:
        """
        The list of managed_database_group_collection.
        """
        return pulumi.get(self, "managed_database_group_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Managed Database Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the Managed Database Group.
        """
        return pulumi.get(self, "state")


class AwaitableGetManagedDatabaseGroupsResult(GetManagedDatabaseGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseGroupsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            managed_database_group_collections=self.managed_database_group_collections,
            name=self.name,
            state=self.state)


def get_managed_database_groups(compartment_id: Optional[str] = None,
                                filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseGroupsFilterArgs']]] = None,
                                id: Optional[str] = None,
                                name: Optional[str] = None,
                                state: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseGroupsResult:
    """
    This data source provides the list of Managed Database Groups in Oracle Cloud Infrastructure Database Management service.

    Gets the Managed Database Group for a specific ID or the list of Managed Database Groups in
    a specific compartment. Managed Database Groups can also be filtered based on the name parameter.
    Only one of the parameters, ID or name should be provided. If none of these parameters is provided,
    all the Managed Database Groups in the compartment are listed.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_groups = oci.DatabaseManagement.get_managed_database_groups(compartment_id=compartment_id,
        id=managed_database_group_id,
        name=managed_database_group_name,
        state=managed_database_group_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str id: The identifier of the resource. Only one of the parameters, id or name should be provided.
    :param str name: A filter to return only resources that match the entire name. Only one of the parameters, id or name should be provided
    :param str state: The lifecycle state of a resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseGroups:getManagedDatabaseGroups', __args__, opts=opts, typ=GetManagedDatabaseGroupsResult).value

    return AwaitableGetManagedDatabaseGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_group_collections=pulumi.get(__ret__, 'managed_database_group_collections'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_managed_database_groups)
def get_managed_database_groups_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseGroupsFilterArgs']]]]] = None,
                                       id: Optional[pulumi.Input[Optional[str]]] = None,
                                       name: Optional[pulumi.Input[Optional[str]]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseGroupsResult]:
    """
    This data source provides the list of Managed Database Groups in Oracle Cloud Infrastructure Database Management service.

    Gets the Managed Database Group for a specific ID or the list of Managed Database Groups in
    a specific compartment. Managed Database Groups can also be filtered based on the name parameter.
    Only one of the parameters, ID or name should be provided. If none of these parameters is provided,
    all the Managed Database Groups in the compartment are listed.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_groups = oci.DatabaseManagement.get_managed_database_groups(compartment_id=compartment_id,
        id=managed_database_group_id,
        name=managed_database_group_name,
        state=managed_database_group_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str id: The identifier of the resource. Only one of the parameters, id or name should be provided.
    :param str name: A filter to return only resources that match the entire name. Only one of the parameters, id or name should be provided
    :param str state: The lifecycle state of a resource.
    """
    ...
