# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult',
    'AwaitableGetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult',
    'get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan',
    'get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult:
    """
    A collection of values returned by getManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlan.
    """
    def __init__(__self__, attribute=None, id=None, managed_database_id=None, opc_named_credential_id=None, plans=None, sql_object_id=None, sql_tuning_advisor_task_id=None):
        if attribute and not isinstance(attribute, str):
            raise TypeError("Expected argument 'attribute' to be a str")
        pulumi.set(__self__, "attribute", attribute)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if sql_object_id and not isinstance(sql_object_id, str):
            raise TypeError("Expected argument 'sql_object_id' to be a str")
        pulumi.set(__self__, "sql_object_id", sql_object_id)
        if sql_tuning_advisor_task_id and not isinstance(sql_tuning_advisor_task_id, str):
            raise TypeError("Expected argument 'sql_tuning_advisor_task_id' to be a str")
        pulumi.set(__self__, "sql_tuning_advisor_task_id", sql_tuning_advisor_task_id)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The text string identifying the type of execution plan.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanPlanResult']:
        """
        A SQL execution plan as a list of steps.
        """
        return pulumi.get(self, "plans")

    @property
    @pulumi.getter(name="sqlObjectId")
    def sql_object_id(self) -> str:
        return pulumi.get(self, "sql_object_id")

    @property
    @pulumi.getter(name="sqlTuningAdvisorTaskId")
    def sql_tuning_advisor_task_id(self) -> str:
        return pulumi.get(self, "sql_tuning_advisor_task_id")


class AwaitableGetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult(GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult(
            attribute=self.attribute,
            id=self.id,
            managed_database_id=self.managed_database_id,
            opc_named_credential_id=self.opc_named_credential_id,
            plans=self.plans,
            sql_object_id=self.sql_object_id,
            sql_tuning_advisor_task_id=self.sql_tuning_advisor_task_id)


def get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan(attribute: Optional[str] = None,
                                                                     managed_database_id: Optional[str] = None,
                                                                     opc_named_credential_id: Optional[str] = None,
                                                                     sql_object_id: Optional[str] = None,
                                                                     sql_tuning_advisor_task_id: Optional[str] = None,
                                                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult:
    """
    This data source provides details about a specific Managed Database Sql Tuning Advisor Tasks Sql Execution Plan resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves a SQL execution plan for the SQL being tuned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_advisor_tasks_sql_execution_plan = oci.DatabaseManagement.get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan(attribute=managed_database_sql_tuning_advisor_tasks_sql_execution_plan_attribute,
        managed_database_id=test_managed_database["id"],
        sql_object_id=test_object["id"],
        sql_tuning_advisor_task_id=test_sql_tuning_advisor_task["id"],
        opc_named_credential_id=managed_database_sql_tuning_advisor_tasks_sql_execution_plan_opc_named_credential_id)
    ```
    <!--End PulumiCodeChooser -->


    :param str attribute: The attribute of the SQL execution plan.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str sql_object_id: The SQL object ID for the SQL tuning task. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str sql_tuning_advisor_task_id: The SQL tuning task identifier. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['attribute'] = attribute
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    __args__['sqlObjectId'] = sql_object_id
    __args__['sqlTuningAdvisorTaskId'] = sql_tuning_advisor_task_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlan:getManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlan', __args__, opts=opts, typ=GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult).value

    return AwaitableGetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult(
        attribute=pulumi.get(__ret__, 'attribute'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        plans=pulumi.get(__ret__, 'plans'),
        sql_object_id=pulumi.get(__ret__, 'sql_object_id'),
        sql_tuning_advisor_task_id=pulumi.get(__ret__, 'sql_tuning_advisor_task_id'))


@_utilities.lift_output_func(get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan)
def get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan_output(attribute: Optional[pulumi.Input[str]] = None,
                                                                            managed_database_id: Optional[pulumi.Input[str]] = None,
                                                                            opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                                            sql_object_id: Optional[pulumi.Input[str]] = None,
                                                                            sql_tuning_advisor_task_id: Optional[pulumi.Input[str]] = None,
                                                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseSqlTuningAdvisorTasksSqlExecutionPlanResult]:
    """
    This data source provides details about a specific Managed Database Sql Tuning Advisor Tasks Sql Execution Plan resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves a SQL execution plan for the SQL being tuned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_advisor_tasks_sql_execution_plan = oci.DatabaseManagement.get_managed_database_sql_tuning_advisor_tasks_sql_execution_plan(attribute=managed_database_sql_tuning_advisor_tasks_sql_execution_plan_attribute,
        managed_database_id=test_managed_database["id"],
        sql_object_id=test_object["id"],
        sql_tuning_advisor_task_id=test_sql_tuning_advisor_task["id"],
        opc_named_credential_id=managed_database_sql_tuning_advisor_tasks_sql_execution_plan_opc_named_credential_id)
    ```
    <!--End PulumiCodeChooser -->


    :param str attribute: The attribute of the SQL execution plan.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str sql_object_id: The SQL object ID for the SQL tuning task. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str sql_tuning_advisor_task_id: The SQL tuning task identifier. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
