# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabasesDatabaseParametersResult',
    'AwaitableGetManagedDatabasesDatabaseParametersResult',
    'get_managed_databases_database_parameters',
    'get_managed_databases_database_parameters_output',
]

@pulumi.output_type
class GetManagedDatabasesDatabaseParametersResult:
    """
    A collection of values returned by getManagedDatabasesDatabaseParameters.
    """
    def __init__(__self__, database_parameters_collections=None, filters=None, id=None, is_allowed_values_included=None, managed_database_id=None, name=None, opc_named_credential_id=None, source=None):
        if database_parameters_collections and not isinstance(database_parameters_collections, list):
            raise TypeError("Expected argument 'database_parameters_collections' to be a list")
        pulumi.set(__self__, "database_parameters_collections", database_parameters_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_allowed_values_included and not isinstance(is_allowed_values_included, bool):
            raise TypeError("Expected argument 'is_allowed_values_included' to be a bool")
        pulumi.set(__self__, "is_allowed_values_included", is_allowed_values_included)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="databaseParametersCollections")
    def database_parameters_collections(self) -> Sequence['outputs.GetManagedDatabasesDatabaseParametersDatabaseParametersCollectionResult']:
        """
        The list of database_parameters_collection.
        """
        return pulumi.get(self, "database_parameters_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabasesDatabaseParametersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAllowedValuesIncluded")
    def is_allowed_values_included(self) -> Optional[bool]:
        return pulumi.get(self, "is_allowed_values_included")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        return pulumi.get(self, "source")


class AwaitableGetManagedDatabasesDatabaseParametersResult(GetManagedDatabasesDatabaseParametersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabasesDatabaseParametersResult(
            database_parameters_collections=self.database_parameters_collections,
            filters=self.filters,
            id=self.id,
            is_allowed_values_included=self.is_allowed_values_included,
            managed_database_id=self.managed_database_id,
            name=self.name,
            opc_named_credential_id=self.opc_named_credential_id,
            source=self.source)


def get_managed_databases_database_parameters(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabasesDatabaseParametersFilterArgs']]] = None,
                                              is_allowed_values_included: Optional[bool] = None,
                                              managed_database_id: Optional[str] = None,
                                              name: Optional[str] = None,
                                              opc_named_credential_id: Optional[str] = None,
                                              source: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabasesDatabaseParametersResult:
    """
    This data source provides the list of Managed Databases Database Parameters in Oracle Cloud Infrastructure Database Management service.

    Gets the list of database parameters for the specified Managed Database. The parameters are listed in alphabetical order, along with their current values.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases_database_parameters = oci.DatabaseManagement.get_managed_databases_database_parameters(managed_database_id=test_managed_database["id"],
        is_allowed_values_included=managed_databases_database_parameter_is_allowed_values_included,
        name=managed_databases_database_parameter_name,
        opc_named_credential_id=managed_databases_database_parameter_opc_named_credential_id,
        source=managed_databases_database_parameter_source)
    ```
    <!--End PulumiCodeChooser -->


    :param bool is_allowed_values_included: When true, results include a list of valid values for parameters (if applicable).
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return all parameters that have the text given in their names.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str source: The source used to list database parameters. `CURRENT` is used to get the database parameters that are currently in effect for the database instance. `SPFILE` is used to list parameters from the server parameter file. Default is `CURRENT`.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['isAllowedValuesIncluded'] = is_allowed_values_included
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    __args__['source'] = source
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabasesDatabaseParameters:getManagedDatabasesDatabaseParameters', __args__, opts=opts, typ=GetManagedDatabasesDatabaseParametersResult).value

    return AwaitableGetManagedDatabasesDatabaseParametersResult(
        database_parameters_collections=pulumi.get(__ret__, 'database_parameters_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_allowed_values_included=pulumi.get(__ret__, 'is_allowed_values_included'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        source=pulumi.get(__ret__, 'source'))


@_utilities.lift_output_func(get_managed_databases_database_parameters)
def get_managed_databases_database_parameters_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabasesDatabaseParametersFilterArgs']]]]] = None,
                                                     is_allowed_values_included: Optional[pulumi.Input[Optional[bool]]] = None,
                                                     managed_database_id: Optional[pulumi.Input[str]] = None,
                                                     name: Optional[pulumi.Input[Optional[str]]] = None,
                                                     opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                     source: Optional[pulumi.Input[Optional[str]]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabasesDatabaseParametersResult]:
    """
    This data source provides the list of Managed Databases Database Parameters in Oracle Cloud Infrastructure Database Management service.

    Gets the list of database parameters for the specified Managed Database. The parameters are listed in alphabetical order, along with their current values.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases_database_parameters = oci.DatabaseManagement.get_managed_databases_database_parameters(managed_database_id=test_managed_database["id"],
        is_allowed_values_included=managed_databases_database_parameter_is_allowed_values_included,
        name=managed_databases_database_parameter_name,
        opc_named_credential_id=managed_databases_database_parameter_opc_named_credential_id,
        source=managed_databases_database_parameter_source)
    ```
    <!--End PulumiCodeChooser -->


    :param bool is_allowed_values_included: When true, results include a list of valid values for parameters (if applicable).
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return all parameters that have the text given in their names.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str source: The source used to list database parameters. `CURRENT` is used to get the database parameters that are currently in effect for the database instance. `SPFILE` is used to list parameters from the server parameter file. Default is `CURRENT`.
    """
    ...
